<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * Classe de base
 * Module de gestion des listes pour l'dition
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
// 2005/02/17 code revision and cleanup sp
copin_include("lib/class.formzoom.php");

/**
 * Classe de base
 * Module de gestion des listes pour l'dition
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
class Formhtml extends FormZoom {
    
  function Formhtml($sql, $key = "", $connect = null){
    $this->FormZoom($sql, $key, $connect);
  }
  
  function get_fieldtr($index, $value){
    if ($this->_fields[$index]["html_type"] != "edithtml") {
      parent::get_fieldtr($index, $value);
    } else { 
      if (!$this->_fields[$index]["temphidden"] && $this->_fields[$index]["tabulator"] == $this->activtab) {
      if ($this->_fields[$index]["label".get_suffix_langue()] != "") {
        echo "<tr><td colspan=2>" . $this->_fields[$index]["label".get_suffix_langue()] . "</td></tr>\n";
      }
      if (!$this->printerfriendly) {
        if (is_ie55_plus()) {
          echo "<tr><td colspan=2><div id=\"control_" . $this->_fields[$index]["name"] .  $this->_fields[$index]["index_zoom"]  . "\">";
          $this->get_edit_buttons($this->_fields[$index]);
          echo "</td></tr><tr>";
        }
        $lehtml = get_control(
                      $this->_fields[$index],
                      $this->format($value, $this->_fields[$index]["display_format"]),
                      ($this->_fields[$index]["ro_save"] && !$flag_insert) ? true : $this->_no_update
                      );
        $lehtml = "<td colspan=2" . (($this->_fields[$index][html_class] != "") ? " class=" . $this->_fields[$index][html_class] : "") . ">" . $lehtml . "</td>";
      } else {        
        $lehtml = get_control($this->_fields[$index], $value, true);
        $lehtml = "<td colspan=2>" . $lehtml . "</td>";
      }
      echo $lehtml;
      echo "</tr>";
      }
    }
  }
  
  function get_edit_buttons($field){   
    $buttons = array (
      "bold" => array (
                       "image" => "gras.gif",
                       "commande" => "document.execCommand('Bold');",
                       "bulle" => "Gras (Ctrl-b)"
                       ),
      "italic" => array (
                       "image" => "italic.gif",
                       "commande" => "document.execCommand('Italic');",
                       "bulle" => "Italique (Ctrl-i)"
                       ),
      "souligne" => array (
                       "image" => "souligne.gif",
                       "commande" => "document.execCommand('Underline');",
                       "bulle" => "Soulign (Ctrl-u)"
                       ),
      "sup" => array (
                       "image" => "sup.gif",
                       "commande" => "document.execCommand('SuperScript');",
                       "bulle" => "Exposant"
                       ),
      "sub" => array (
                       "image" => "sub.gif",
                       "commande" => "document.execCommand('SubScript');",
                       "bulle" => "Indice"
                       ),
      "normal" => array (
                       "image" => "normal.gif",
                       "commande" => "document.execCommand('RemoveFormat');",
                       "bulle" => "Normal"
                       ),
      "separator1" => array (
                       "image" => "separator.gif",
                       "commande" => "",
                       "bulle" => ""
                       ),
      "h1" => array (
                       "image" => "h1.gif",
                       "commande" => "document.execCommand('formatBlock','false','<h1>');",
                       "bulle" => "En-tte 1"
                       ),
      "h2" => array (
                       "image" => "h2.gif",
                       "commande" => "document.execCommand('formatBlock','false','<h2>');",
                       "bulle" => "En-tte 2"
                       ),
      "h3" => array (
                       "image" => "h3.gif",
                       "commande" => "document.execCommand('formatBlock','false','<h3>');",
                       "bulle" => "En-tte 3"
                       ),
      "h_" => array (
                       "image" => "h_.gif",
                       "commande" => "document.execCommand('formatBlock','false','<h6>');",
                       "bulle" => "Enlever l'en-tte"
                       ),
      "separator2" => array (
                       "image" => "separator.gif",
                       "commande" => "",
                       "bulle" => ""
                       ),
      "puce" => array (
                       "image" => "puce.gif",
                       "commande" => "document.execCommand('InsertUnorderedList');",
                       "bulle" => "Liste  puces"
                       ),
      "indent" => array (
                       "image" => "indent.gif",
                       "commande" => "document.execCommand('Indent');",
                       "bulle" => "Augmenter le retrait"
                       ),
      "outdent" => array (
                       "image" => "outdent.gif",
                       "commande" => "document.execCommand('Outdent');",
                       "bulle" => "Rduire le retrait"
                       ),
      "separator3" => array (
                       "image" => "separator.gif",
                       "commande" => "",
                       "bulle" => ""
                       ),
      "link" => array (
                       "image" => "link.gif",
                       "commande" => "document.getElementById('wysiwyg_" . $field["name"] . "').focus(); document.execCommand('CreateLink');",
                       "bulle" => "Crer un hyperlien (Ctrl-k)"
                       ),
      "unlink" => array (
                       "image" => "unlink.gif",
                       "commande" => "document.execCommand('Unlink');",
                       "bulle" => "Enlever un hyperlien"
                       ),
      "target" => array (
                       "image" => "link.gif",
                       "commande" => "document.execCommand('CreateBookmark', true, 'temp');",
                       "bulle" => "Crer une cible"
                       ),
      "image" => array (
                       "image" => "img.gif",
                       "commande" => "document.getElementById('wysiwyg_" . $field["name"] . "').focus(); document.execCommand('insertImage', true);",
                       "bulle" => "Inserer une image"
                       )
                        
      
    );
    $the_buttons = "<table class=\"bouttons\" cellspacing=0><tr>";
    while (list($index, $subarray) = each($buttons)) {
      if ($subarray["commande"] == "")
        $the_buttons .= "<td><img src=\"".sget("forms_image_dir")."html" . $subarray["image"] . "\" height=\"22\" width=\"" . ($subarray["image"] == "separator.gif" ? 5 : 22) . "\" border=0 unselectable=\"on\"></td>";
      else
        $the_buttons .= "<td onmouseup=\"" . $subarray["commande"] . "\"><img src=\"".sget("forms_image_dir")."html" . $subarray["image"] . "\" border=0 alt=\"" . $subarray["bulle"] . "\" unselectable=\"on\"></td>";
    }
    $the_buttons .= "</tr></table>";
    echo $the_buttons; 
  }
  
  function edithtml($fieldname){
    parent::edithtml($fieldname);
    
    $this->set_property($fieldname, "width", "100%");
    $this->set_property($fieldname, "height", "250");
    $this->set_property($fieldname, "html_class", "contenteditablehtml");
  }
  
}
?>