<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * Classe de base
 * Noyau commun pour la base de donnes, affichage de base du contenu d'une table
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
 
 // 29/07/2004 - plus de fichier labelmanager.php
// 2005/02/17 code revision and cleanup sp
// 2005/08/08 Compatibilite avec magic quote = on

copin_include("lib/class.sql.php");
copin_include("lib/db.php");
copin_include("lib/class.formroot.php");

/**
 * Classe de base
 * Noyau commun pour la base de donnes, affichage de base du contenu d'une table
 * @package Jade
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */

class FormBase extends FormRoot{
  var $_fields;
  var $_key;
  var $_sql;
  var $_sort_order;
  var $_no_navigate;
  var $_no_save;
  var $_no_insert;
  var $_no_delete;
  var $_no_update;
  var $_no_cancel;
  var $_joinfield;
  var $_filter_value;
  var $_index;
  var $_help_wanted;
  var $_help_anchor;
  var $_buttonlabel_add;
  var $_buttonlabel_save;
  var $_buttonlabel_erase;
  var $_buttonlabel_cancel; 
  var $_buttonlabel_erase_msg;
  var $_buttonlabel_erase_ligne_msg;
  var $_buttonlabel_multierase_msg;
  var $_alt_bd;
  
  var $_type_formulaire; /* master, detail, zoom*/
  var $_master; 
  var $details;
  var $zoom;
  var $searchsiblings;
  var $_parent;
   
  function FormBase($sql, $key = "", $connect = null) {
    $this->FormRoot();
    if (isset($connect)) {
      $this->_alt_bd = $connect;
    } else
      $this->_alt_bd = null;
      
    $this->_buttonlabel_add = get_str("btn_buttonlabel_add", "FormBase");
    $this->_buttonlabel_save = get_str("btn_buttonlabel_save", "FormBase");
    $this->_buttonlabel_erase = get_str("btn_buttonlabel_erase", "FormBase");
    $this->_buttonlabel_cancel = get_str("btn_buttonlabel_cancel", "FormBase");
    $this->_buttonlabel_erase_msg = get_str("msg_buttonlabel_erase_msg", "FormBase");
    $this->_buttonlabel_erase_ligne_msg  = get_str("msg_buttonlabel_erase_ligne_msg", "FormBase");
    $this->_buttonlabel_multierase_msg = get_str("msg_buttonlabel_multierase_msg", "FormBase");
    
    $this->_type_formulaire = "master";
    $this->_sql = new SqlClass($sql, $connect);
    $this->_key = ($key == "") ? $this->_sql->_modifie_table_update : $key;
    $this->_sql->SetKey($this->_key);
    $this->sort_order($this->_sql->get_champ_orderby() . " " . 
    $this->_sql->get_direction_orderby());

    $this->init_fields();
    $this->default_field_definition["field_type"] = "string";
    $this->default_field_definition["field_len"] = 50;
    $this->default_field_definition["field_null"] = "O";

    $this->_no_save = false;
    $this->_no_update = false;
    $this->_no_navigate = false;
    $this->_no_insert = false;
    $this->_no_delete = false;
    $this->_no_cancel = true;
    $this->_help_wanted = false;
    $this->_help_anchor = "";
    $this->_help_height = 400;
    $this->on_insert_focus = "";
    $this->alt_order = null;
  }
  
  function init_fields(){
    $table_description = $this->_sql->field_description;
    if(is_array($table_description)) {
      reset($table_description);
      while (list($index, $subarray) = each($table_description)) {
         $this->init_field($index, $subarray); 
      }
    }
  }
   
  function init_field($index, $subarray, $binded = true){
    $this->_fields[$index]["label"] = get_label($index);
    $v_type = std_type($subarray["field_type"]);
    $this->_fields[$index]["validation_type"] = ($v_type == "datetime" ? "date" : $v_type);
    $this->_fields[$index]["maxlen"] = $subarray["field_len"];
    $this->_fields[$index]["null"] = $subarray["field_null"];
    $this->_fields[$index]["visible"] = "O"; 
    $this->_fields[$index]["html_attribut"] = "";
    $this->_fields[$index]["oui"] = "O"; 
    $this->_fields[$index]["non"] = "N"; 
    $this->_fields[$index]["binded"] = $binded; 
  }
  
  function add_field($fieldname, $position, $binded = true) {
    if ($binded) {
      $this->_sql->AddField($fieldname);
    }
    $this->_fields = array_insert($this->_fields, array($fieldname => array()), $position);
    $this->init_field($fieldname, 
      $binded ? $this->_sql->field_description[$fieldname] : $this->default_field_definition, $binded);
  }
    
  function on_insert_focus($fieldname){
    $this->on_insert_focus = $fieldname;
  }
  
  function globaltable($value = true){
    $this->globaltable = $value;
  }
  
  function ouinon_value($fieldname, $oui, $non){
    $this->set_property($fieldname, "oui", $oui);
    $this->set_property($fieldname, "non", $non);
  }
  
  function get_style_bouton($image){
    return " style=\"background-image: url(" . 
           sget("forms_image_dir") . "$image); background-repeat: no-repeat; background-position: center; height: 27; width: 27;\" ";
  }

  function get_img_button($img, $name, $alt, $js){
    return "<input type=\"button\" class=\"formeZoombutton\" " . 
             $this->get_style_bouton($img) . " name=\"$name\" title=\"$alt\" $js>";
  }
  /**
  * @todo use original value wich would be the value at initialisation like in html_attribut
  */
  function set_property($fieldname, $property, $value){
    if (is_array($fieldname)){
      while (list($index, $subarray) = each($fieldname))
       if (isset($this->_fields[$subarray]))
         $this->_fields[$subarray][$property] = $value;
    } else {
      if (isset($this->_fields[$fieldname]))
        $this->_fields[$fieldname][$property] = $value;
    }
  }
  function html_attribut($fieldname, $html_attribut){
    $this->set_property($fieldname, "html_attribut", $html_attribut);
    $this->set_property($fieldname, "old_html_attribut", $html_attribut);
  }
  
  function calendar_alternate_initfield($fieldname, $altfield){
    $this->set_property($fieldname, "calendar_alternate_initfield", $this->_fields[$altfield]["name"]);
  }
  
  function get_tdcontrol($specs, $value, $no_update = false, 
    $boutonjsro = "", $formename = "forme", $connect = null) {
    return get_control($specs, $value, $no_update, $boutonjsro, $formename, $connect);
  }
  // not used yet : to be validated
  function context($the_context, $icon = ""){
    $this->context = $the_context;
    $this->contexticon = $icon;
  }
  function formname($formname){
    $this->formname = $formname;
  }
  function no_form(){
    $this->no_form = true;
  }
  
  function get_index(){
    return $this->_index;
  }
  function set_index($newindex){
    $this->_index = $newindex;
  }
  
  function set_buttonlabel_add($buttonlabel) {
    $this->_buttonlabel_add = $buttonlabel;
  }
  
  function set_buttonlabel_save($buttonlabel) {
    $this->_buttonlabel_save = $buttonlabel;
  }

  function set_buttonlabel_erase($buttonlabel) {
    $this->_buttonlabel_erase = $buttonlabel;
  }

  function set_buttonlabel_cancel($buttonlabel) {
    $this->_buttonlabel_cancel = $buttonlabel;
  }
  // not supported yet
  function help_height($new_height){
    $this->_help_height = $new_height;
  }
  function help_wanted($an_anchor = null){
    $this->_help_anchor = $an_anchor;
    $this->_help_wanted = true;
  }
  function help_me_button(){
    $the_action = gget("action");
    if ($the_action == "") $the_action = "helpme";
    return "<a href=\"#\" onclick=\"javascript:ia_openIT('" . get_constant("PATH_HELP") . "?action=$the_action" . (is_primary_language() ? "" : "&langue=a") . "&hauteur=" . $this->_help_height  . "', 563, " . $this->_help_height . ", 'iaaide$the_action');\"><img src=\"".sget("image_dir")."but_moduleaide_sml" . get_suffix_langue() . ".gif\" width=\"108\" height=\"51\" border=\"0\"></a>";
  }
  
  function add_detail($name){  
    $this->_type_formulaire = "master";
    if (!isset($this->details))
      $this->details = array();
    array_push($this->details, $name);
  }
  function add_searchsibling($name){  
    $this->_type_formulaire = "master";
    if (!isset($this->searchsiblings))
      $this->searchsiblings = array();
    array_push($this->searchsiblings, $name);
  }
  
  function set_master($master_name, $joinfield){
    $this->_type_formulaire = "detail";
    $this->_master = $master_name;
    $this->_joinfield = $joinfield;
  }
  
  function add_zoom($name){
    $this->zoom = $name;
  }
  function set_parent($parent_name){
    $this->_parent = $parent_name;
    $this->_type_formulaire = "zoom";
  }
  
  function hide_header() {
    $this->_hide_header = true;
  }
  function show_header() {
    $this->_hide_header = false;
  }

  function hide_footer() {
    $this->_hide_footer = true;
  }
  function show_footer() {
    $this->_hide_footer = false;
  }
  
  function url_move_last(&$fm) {
    $this->_index = $this->get_last();
    $this->show($fm);
  }  
  function url_move_first($fm){
    $this->_index = $this->get_first();
    $this->show($fm);
  }  
  function url_move_prev(&$fm) {
    $this->_index = $this->get_prev();
    $this->show($fm);
  }  
  function url_move_next(&$fm) {
    $this->_index = $this->get_next();
    $this->show($fm);
  }
  /**
   * @todo implement of printerfriendly in the skins
   */
  function show(&$fm){
    if ($this->_type_formulaire == "detail"){
      $fm->dispatch($this->_master, "show"); 
    } else { 
      if (isset($fm->_forms[$this->_name]["details"])){
        reset($fm->_forms[$this->_name]["details"]);
        while (list($index, $subarray) = each($fm->_forms[$this->_name]["details"])){
          $the_form = &$fm->get_form($subarray);
          $the_form->_filter_value = $this->get_index();
		          
		      $the_form->_sql->RebuiltSql();
		      $the_form->_sql->WhereAnd($the_form->_joinfield . " = " . 
		            wrapdata($the_form->_filter_value, 
		                $the_form->_sql->field_description[strtolower($this->_key)]["field_type"])
		            );
		      $the_form->_sql->set_page_count();
        }
        
        if (gget("printerfriendly") == "O") {
          $old_no_update = $this->_no_update;
          $old_hide_header  = $this->_hide_header;
          $this->_no_update = true;
          $this->_hide_header = true;
          $this->printerfriendly = true;
        }
        $this->_display($fm);
        if (gget("printerfriendly") == "O") {
          $this->printerfriendly = false;    
          $this->_no_update = $old_no_update; 
          $this->_hide_header = $old_hide_header;
        }
        
        reset($fm->_forms[$this->_name]["details"]);
        while (list($index, $subarray) = each($fm->_forms[$this->_name]["details"])){
                  $the_form = &$fm->get_form($subarray);
                  if (gget("printerfriendly") == "O") {
                    $old_no_update = $the_form->_no_update;
                    $old_hide_header  = $the_form->_hide_header;
                    $the_form->_no_update = true;
                    $the_form->_hide_header = true;
                    $the_form->printerfriendly = true;
                  }
                  $the_form->_display($fm);
                  if (gget("printerfriendly") == "O") {
                    $the_form->printerfriendly = false;    
                    $the_form->_no_update = $old_no_update; 
                    $the_form->_hide_header = $old_hide_header;
                  }
        }
      } else {
        if (gget("printerfriendly") == "O") {
          $old_no_update = $this->_no_update;
          $old_hide_header  = $this->_hide_header;
          $this->_no_update = true;
          $this->_hide_header = true;
          $this->printerfriendly = true;
        }
        $this->_display($fm);
        if (gget("printerfriendly") == "O") {
          $this->printerfriendly = false;    
          $this->_no_update = $old_no_update; 
          $this->_hide_header = $old_hide_header;
        }
      }
      if ($this->globaltable) 
        echo "</td></tr></table>";
    }
  }
  
  function url_orderby(&$fm){
    $this->sort_order(gget("index") . " " . gget("order"));
    $this->url_move_first($fm);
  }
  function switch_orderby(){
    $this->_sql->switch_orderby();
  }
  
  function no_update(){
    $this->_no_update = true;
  }  
  function yes_update() {
    $this->_no_update = false;
  }
  function no_save(){
    $this->_no_save = true;
  }
  function no_insert(){
    $this->_no_insert = true;
  }
  function no_delete(){
    $this->_no_delete = true;
  }
  function no_cancel(){
    $this->_no_cancel = true;
  }
 
  function no_navigate(){
    $this->_no_navigate = true;
  }
  
  function hide($fieldname){
    if (is_array($fieldname)){
      while (list($index, $subarray) = each($fieldname))
       if (isset($this->_fields[$subarray])) {
         $this->_fields[$subarray]["visible"] = "N";
         if ($this->_fields[$subarray]["detailed"])
           $this->_fields[$subarray]["detailed"] = false;
       }
    } else {
      if (isset($this->_fields[$fieldname]))
        $this->_fields[$fieldname]["visible"] = "N";
         if ($this->_fields[$fieldname]["detailed"])
           $this->_fields[$fieldname]["detailed"] = false;
    }
  }
  
  function unhide($fieldname){
    $this->set_property($fieldname, "visible", "O");
  }
  
  function label($fieldname, $newlabel){
    $this->set_property($fieldname, "label", $newlabel);
  }
  
  function width($fieldname, $newwidth){
    $this->set_property($fieldname, "default_width", false);
    $this->set_property($fieldname, "width", $newwidth);
  }
  
  function display_format($fieldname, $newformat){
    $this->set_property($fieldname, "display_format", $newformat);
  }
  function highlightreg($fieldname, $highlightreg){
    $this->_fields[$fieldname]["highlightreg"] = $highlightreg;
  }
  
  function html_class($fieldname, $html_class){
    $this->set_property($fieldname, "html_class", $html_class);
  }
  
  function html_type($fieldname, $html_type){
    $this->set_property($fieldname, "html_type", $html_type);
  }
  
  function pick_multiple_list($fieldname, $leschoix){
    $this->set_property($fieldname, "html_type", "multipleselect");
    $this->set_property($fieldname, "leschoix", $leschoix);
  }
  
  function pick_multiple_listfunction($fieldname, $leschoixfunction){
    $this->set_property($fieldname, "html_type", "mutipleselect");
    $this->set_property($fieldname, "leschoixfunction", $leschoixfunction);
  }
  
  function pick_list($fieldname, $leschoix){
    $this->set_property($fieldname, "html_type", "select");
    $this->set_property($fieldname, "leschoix", $leschoix);
  }
  
  function pick_listfunction($fieldname, $leschoixfunction){
    $this->set_property($fieldname, "html_type", "select");
    $this->set_property($fieldname, "leschoixfunction", $leschoixfunction);
  }
  
  function pick_listaddself($fieldname, $field_description, $addself = true){
    $this->set_property($fieldname, "addself", $addself);
    $this->set_property($fieldname, "field_description", $field_description);
  }
  
  function pick_listcolor($fieldname){
    $this->set_property($fieldname, "html_type", "selectcolor");
    $this->set_property($fieldname, "lbl_default", get_str("lbl_default_color", "FormZoom"));
  }
  function pick_lbl_default($fieldname, $value){
    $this->set_property($fieldname, "lbl_default", $value);
  }
  
  function default_color($fieldname, $value) {
    $this->set_property($fieldname, "default_color", $value);
  }
  
  function format($value, $format, $highlightreg = "", $fld_name = ""){
    //error_log_dev ("format : $format \nChamp : $fld_name \nValeur : $value");
    if (isset($format) && $format != "")
      if (preg_match("/^prefix:(.+)/", $format, $matches)) {
        $value = $matches[1] . $value;
      } else {
        switch ($format){
          case "shortdate":
            $value = preg_replace("/-/", "\/", substr($value, 0, 10));
            break;
          case "datetime":
            $value = preg_replace("/-/", "\/", substr($value, 0, 16));
            break;
          case "shorttime":
            $value = substr($value, 0, 5);
            break;
          case "dateyear":
            $value = substr($value, 0, 4);
            break;
          case "dateyearmonth":
            $value = preg_replace("/-/", "\/", substr($value, 0, 7));
            break;
          case "pourcentage":
            $value = $value . "%";
            break;
          case "pourcentagezoom":
            $value = $value;
            break;
          case "dollar":
            $value = number_format($value, 2);
            break;
          case "comptable":
            if (preg_match("/^-(.*)/", trim($value), $matches))
              $value = "(" . number_format($matches[1], 2) . ")";
            else
              $value = number_format($value, 2);
            break;
          case "lower":
            $value = strtolower($value);
            break;
          case "ouinon":
          if ($value == $this->_fields[$fld_name]["oui"]) 
            $value = get_str("lbl_yes", "FromBase");
          else
            $value = get_str("lbl_no", "FromBase");
          break;
        }       
      }

	// compatibility with magic quote on (default in php)
	if (get_magic_quotes_gpc()) {
	  $value = stripslashes($value);
	} else {
	  if (isset($format) && $format != "") 
	    $value = stripslashes($value); 
	}
  
    return $value;
  }
  
  function sort_order($neworder){
    if (preg_match("/\sDESC $/i", $neworder))
      $direction = " DESC";
    else
      $direction = " ASC"; 
    $this->_sql->SetOrderBy($neworder. ", " . 
    ($this->alt_order ? $this->alt_order : $this->_key) . $direction);
  }
  
  function alt_order($alt_order){
    $this->alt_order = $alt_order;
  }
  
  function alt_table($table_name){
    $this->_sql->SetAltUpdateTable($table_name);
    $this->_sql->SetAltInsertTable($table_name);
    $this->_sql->SetAltDeleteTable($table_name);
  }
  function alt_update_table($table_name){
    $this->_sql->SetAltUpdateTable($table_name);
  }
  function alt_insert_table($table_name){
    $this->_sql->SetAltInsertTable($table_name);
  }
  function alt_delete_table($table_name){
    $this->_sql->SetAltDeleteTable($table_name);
  }
  function get_key() {
    return $this->_key;
  }
  
  function ShowHeader() {
    echo "<tr>";
    while (list($index, $subarray) = each($this->_fields))
      echo "<th>$subarray[label]</th>";
    echo "</tr>";
  }
  /**
    * @todo implementation of set_rs
    */
  function _display(&$fm) { 
    echo "<table class=\"forme\">";
    $this->ShowHeader();
    $rs = $this->_sql->Select();
    while (list($index, $subarray) = each($rs)){ 
      echo "<tr>";
      while (list($index2, $subarray2) = each($subarray)) 
        echo "<td>$subarray2&nbsp</td>";
      echo "</tr>";
    }
    echo "</table>";
   } 
}
?>