<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * class.cookie.php
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
// 2005/02/17 code revision and cleanup sp
// ---------------------------------------------------------------
// int setcookie ( string name [, string value [, int expire
//          [, string path [, string domain [, int secure]]]]])
//
// Version  Description
// ---------------------------------------------------------------
// 1.0.0    Gestion des cookies
// ---------------------------------------------------------------

/**
 * class.cookie.php
 * @package Jade
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */

class Cookie {

function set_cookie($name, $value, $machinelevel = false) {
  if (!isset($_SESSION[get_constant($machinelevel ? "MACHINE_NAME" : "SITE_NAME")]["the_cookie"])) {
    $the_cookie = new cookie();
    $_SESSION[get_constant($machinelevel ? "MACHINE_NAME" : "SITE_NAME")]["the_cookie"] = $the_cookie;
  } else {
    $the_cookie = $_SESSION[get_constant($machinelevel ? "MACHINE_NAME" : "SITE_NAME")]["the_cookie"];
  } 
  $the_cookie->set_property(get_constant($machinelevel ? "MACHINE_NAME" : "SITE_NAME") . $name, $value);
  $the_cookie->write_cookie($the_cookie->get_year_in_sec(5));
}

function get_cookie($name, $machinelevel = false) {
  if (!isset($_SESSION[get_constant($machinelevel ? "MACHINE_NAME" : "SITE_NAME")]["the_cookie"])) {
    $the_cookie = new cookie();
    $_SESSION[get_constant($machinelevel ? "MACHINE_NAME" : "SITE_NAME")]["the_cookie"] = $the_cookie;
  } else {
    $the_cookie = $_SESSION[get_constant($machinelevel ? "MACHINE_NAME" : "SITE_NAME")]["the_cookie"];
  } 
  $cookie = $the_cookie->read_cookie(array(get_constant($machinelevel ? "MACHINE_NAME" : "SITE_NAME").$name));
  return $cookie[get_constant($machinelevel ? "MACHINE_NAME" : "SITE_NAME").$name];
}

    var $_prop_array = array();

    //---------------------------------------------------------------------------------
    // Parametre Name=Value a conserver dans 1 ou plusieur cookie
    // name     = Nom de la proprit
    // value    = Valeur de la proprite
    // Note: Une valeur peut etre modifi si affect une seconde fois
    //       avant write_cookie()
    //---------------------------------------------------------------------------------
    function set_property($name, $value) {
        $this->_prop_array[$name] = $value;
    }

    //---------------------------------------------------------------------------------
    // Retire les cookies du header du document HTML
    // Retourne un array de Name=Value
    // $property_name_array = Array contenant le nom de tout les proprites a lire
    //---------------------------------------------------------------------------------
    function read_cookie($property_name_array) {
        $array_temp = array();
        while ( list($id, $name) = each($property_name_array) ) {
            $array_temp[$name] = cget($name);
        }
        return $array_temp;
    }


    //---------------------------------------------------------------------------------
    // Ajoute les cookies dans le header du document HTML
    // $expire_second   = Optionel - Dlais d'expiration (par default "end of session")
    //---------------------------------------------------------------------------------
    function write_cookie($expire_second = 0) {
        if ($expire_second > 0) {
            // formate la date
            $expire_second = time() + $expire_second;
        }
        while ( list ($name, $value) = each ($this->_prop_array) ) {
            setcookie($name, $value, $expire_second, get_url_path());
        }
    }

    //---------------------------------------------------------------------------------
    // Retire les cookies du header du document HTML
    // Retourne un array de Name=Value
    // $property_name_array = Array contenant le nom de tout les proprites a retires
    //---------------------------------------------------------------------------------
    function delete_cookie($property_name_array) {
        while ( list($id, $name) = each($property_name_array) ) {
            setcookie( $name, "", time() - 3600 );
        }
    }

    //-------------------------------------------------------------
    // Conversion d'un nombre d'anne en seconde
    //-------------------------------------------------------------
    function get_year_in_sec($year) {
        return ((3600*24)*360) * $year;
    }

}

?>