<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * browser detection library server side
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */

//  ===========================================================================
//  Title:  browser.php     (Dtection des parametre du navigateur WWW)
//  Author:	Les consultants interaction.
//  Date:   6 mars 2002
//  Version	Description
//  Update: is_opera() dtecte rellement Opera
//          get_opera_version() dtecte la version d'opra
//  ------------------------------------------------------------------
//  1.0.0   Note: La function is_mac() n'as pas t teste
//  1.1.0   is_netscape601
//  1.2.0   is_netscape6_plus()  NE RECONNAIT PAS LES VERSION SUPRIEUR a 9
//  1.2.1   is_netscape6_plus() correction > 9
//          is_netscape477_plus()
//          is_ie50_plus()
//  1.3.0   is_opera60_plus()
//  1.4.0 	is_opera()
//  1.5.0 	is_safari()
// 2005/02/17 code revision and cleanup sp
//  ===========================================================================
/*
examples of connect string
camino Mozilla/5.0 (Macintosh; U; PPC Mac OS X Mach-O; en-US; rv:1.0.1) Gecko/20030306 Camino/0.7
internet explorer Mozilla/4.0 (compatible; MSIE 5.22; Mac_PowerPC)
safari Mozilla/5.0 (Macintosh; U; PPC Mac OS X; en-us) AppleWebKit/85.7 (KHTML, like Gecko) Safari/85.6
Mozilla Firebird  Mozilla/5.0 (Macintosh; U; PPC Mac OS X Mach-O; en-US; rv:1.5) Gecko/20031026 Firebird/0.7
netscape 6 Mozilla/5.0 (Macintosh; U; PPC; en-US; rv:0.9.2) Gecko/20010728 Netscape6/6.1

Netscape 7.1 Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.4) Gecko/20030624 Netscape/7.1 (ax)
internet explorer Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)
Firefox Mozilla/5.0 (Windows; U; Windows NT 5.0; rv:1.7.3) Gecko/20040913 Firefox/0.10.1
Mozilla Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:1.5) Gecko/20031007
Netscape 7.2 Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:1.7.2) Gecko/20040804 Netscape/7.2 (ax)*/
/**
  * 
  */
function without_iframe() {
  return (is_ie() && is_mac());
}

/**
  * 
  */
function without_background() {
  return (is_safari() || is_netscape601());
}

/**
  * Used in html.php only for skins with iframepopup.
  * If true, the old calendar method will be used instead of the iframe method.
  */
function odlcalendar() {
  return (is_safari() || is_netscape601() || (is_ie() && is_mac()));
}

/**
  * Return true if on Camino navigator
  */
function is_camino() {
    return preg_match("/Camino/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Firebird navigator
  */
function is_firebird() {
    return preg_match("/Firebird/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Firebird navigator
  */
function is_firefox() {
    return preg_match("/Firefox/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Safari navigator
  */
function is_safari() {
    return preg_match("/safari/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Mozilla navigator
  */
function is_mozilla() {
    return preg_match("/Gecko\/20010316/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Netscape 4.76 navigator
  */
function is_netscape476() {
	return preg_match("/Mozilla\/4.76/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if called by a search engine
  */
function is_webot() {
	return !is_ie() && !preg_match("/Mozilla/i", getenv("HTTP_USER_AGENT")) && preg_match("/jeeves|bot|dig|craw|http:|Lynx/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Netscape 4.77 or more navigator
  */
function is_netscape477_plus() {
  // if major is 4 and minor is higher than 76
  if ( preg_match("/Mozilla\/4\.7[7-9]/i", getenv("HTTP_USER_AGENT")) ) {
      return true;
  // if major is higher than 4
  } else if ( preg_match("/Mozilla\/([5-9]|[1-9][0-9]+)\./i", getenv("HTTP_USER_AGENT")) ) {
      return true;
  } else {
      return false;
  }
}

/**
  * Return true if on Netscape 4.79 navigator
  */
function is_netscape479() {
    return preg_match("/Mozilla\/4.79/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Netscape 6.01 navigator
  */
function is_netscape601() {
    return preg_match("/Gecko\/20010131 Netscape6\/6.01/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Netscape navigator
  */
function is_netscape() {
 		if (preg_match("/Gecko[ \/]([0-9\.]+)/",getenv("HTTP_USER_AGENT"))){
			return true;
		} elseif(is_netscape479() || is_netscape476() || is_netscape601() || is_netscape6_plus()){
			return true;	
		}	else{
			return false;
		}
}

/**
  * Return true if on Netscape 6 or higher navigator
  */
function is_netscape6_plus() {
	if(preg_match("/Netscape([6-9]\/([6-9]|[1-9][0-9]+)\.?[0-9])/i", getenv("HTTP_USER_AGENT")))
		return true;
	if(preg_match("/Gecko[ \/]([0-9\.]+)/",getenv("HTTP_USER_AGENT")))
		return true;
	return false;
}

/**
  * Return true if on Internet Explorer 5.5 navigator
  */
function is_ie55() {
    return preg_match("/MSIE 5.5/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Internet Explorer 6.0 navigator
  */
function is_ie6() {
    return preg_match("/MSIE 6.0/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Internet Explorer navigator
  */
function is_ie() {
    return preg_match("/MSIE/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Internet Explorer 5.5 or higher navigator
  */
function is_ie50_plus() {
  return preg_match("/MSIE ([1-9][0-9]|[5-9])\.?[0-9]*/", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Internet Explorer 5.5 or higher navigator
  */
function is_ie55_plus() {
  return preg_match("/MSIE 5\.[5-9]*/", getenv("HTTP_USER_AGENT"))
    || preg_match("/MSIE ([1-9][0-9]|[6-9])\.?[0-9]*/", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Konqueror navigator
  */
function is_konqueror() {
    return preg_match("/Konqueror/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Opera 6.0 or higher navigator
  */
function is_opera60_plus() {
  return preg_match("/Opera\/([1-9][0-9]|[6-9])\./", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Opera navigator
  */
function is_opera(){
	if (eregi('Opera[ \/]([0-9\.]+)' , getenv("HTTP_USER_AGENT"), $a)) {
		return true;
	}
	else {
		return false;
	}
}

/**
  * Return true if on Windows operating system
  */
function is_win() {
    return preg_match("/Windows/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Linux operating system
  */
function is_linux() {
    return preg_match("/Linux X11/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return true if on Macintosh operating system
  */
function is_mac() { 
    return preg_match("/Macintosh|Mac/i", getenv("HTTP_USER_AGENT"));
}

/**
  * Return the windows version
  */
function get_window_system(){  
    preg_match("/Windows [\w|\s|.]*/i", getenv("HTTP_USER_AGENT"), $matches);
    return $matches[0];
}

/**
  * Return the Internet Explorer version
  */
function get_ie_version(){
  preg_match("/MSIE ([1-9][0-9]*\.?[0-9]*)/", getenv("HTTP_USER_AGENT"), $matches);
  return $matches[1];
}

/**
  * Return the Netscape version
  */
function get_netscape_version(){
	$ver[20030208] = "7.02";
	$ver[20021120] = "7.01";
	$ver[20020823] = "7.0";
	$ver[20020730] = "7.0 Mac";
	$ver[20020512] = "7.0b1";
	$ver[20020220] = "7.0";
	$ver[20020508] = "6.2.3";
	$ver[20020314] = "6.2.2";
	$ver[20011128] = "6.2.1";
	$ver[20010726] = "6.1";

  preg_match("/Gecko[ \/]([0-9\.]+)/",getenv("HTTP_USER_AGENT"),$matches);
	$version = $ver[$matches[1]];

	if(!$version){
		preg_match("/Netscape([6-9]\/([6-9]|[1-9][0-9]+)\.?[0-9])/i", getenv("HTTP_USER_AGENT"), $matches);
		$version = $matches[1];
	}
	if(!$version){
		preg_match('/([[:alnum:]]+)[ \/v]*([0-9\.]+)/', getenv("HTTP_USER_AGENT"), $matches);
		$version = $matches[2]; 
	}
	return $version;
} 

/**
  * Return the Opera version
  */
function get_opera_version(){
	eregi("Opera[ \/]([0-9\.]+)" , getenv("HTTP_USER_AGENT"), $matches);
	return $matches[1];
}

/**
  * Return the Browser version
  */
function get_browserversion(){
  $browser = get_browserkind();
  if($browser == "Opera")
		$version = get_opera_version();
	elseif ($browser == "Internet Explorer")
    $version = get_ie_version();
  elseif ($browser == "Netscape")
    $version = get_netscape_version();
  return $version;
}

/**
  * Return the Browser kind
  */
function get_browserkind(){
	if (is_konqueror())
    $browser = "Konqueror";
  elseif (is_safari())
    $browser = "Safari";
  elseif (is_camino())
    $browser = "Camino";
  elseif (is_firebird())
    $browser = "Firebird";
  elseif (is_opera60_plus() || is_opera())
    $browser = "Opera";  
	elseif (is_ie())
    $browser = "Internet Explorer";
  elseif (is_netscape())
    $browser = "Netscape";
  return $browser;
  
}

/**
  * Return the operating system
  */
function get_system(){
  if (is_win())
    $system = get_window_system();
  elseif (is_linux())
    $system =  "Linux";
  elseif (is_mac())
    $system =  "Macintosh";
  return $system;
}

/**
  * Return true if the navigator satisfie the minimum requirement :
  * Netscape 6, Internet Explorer 5.0, Opera 6.0, Safari.  Any other navigator
  * that passes the test but is passing a false navigator string will also work.
  */
function acceptable() {
 return (is_netscape6_plus() || is_ie50_plus() || is_opera60_plus() || is_safari()); 
}

?>