/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * browser detection library
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
//=================================================================
// Title:	browser.js
// Date:	27 dec 2002
// Version	Description
//---------------------------------------------------------
// 1.0.0		Detection du navigateur 
//=================================================================

var browser_appVersion = navigator.appVersion.toLowerCase();
var browser_userAgent = navigator.userAgent.toLowerCase();

var is_ie_5_up = (browser_userAgent.indexOf("msie 5") != -1) || 
	(browser_userAgent.indexOf("msie 6") != -1);
var is_ie_5 = (browser_userAgent.indexOf("msie 5 ") != -1);	
var is_ie_5_5 = (browser_userAgent.indexOf("msie 5.5") != -1);
var is_ie_6_0 = (browser_userAgent.indexOf("msie 6.0 ") != -1);

var is_netscape_4_up = (browser_userAgent.indexOf("mozilla/4") != -1 &&	browser_userAgent.indexOf("msie") == -1) ||
	(browser_userAgent.indexOf("netscape6/") != -1) ||
	(browser_userAgent.indexOf("netscape/7") != -1);
var is_netscape_4_76 = (browser_userAgent.indexOf("mozilla/4.76 ") != -1);
var is_netscape_4_79 = (browser_userAgent.indexOf("mozilla/4.79 ") != -1);
var is_netscape_4_8 = (browser_userAgent.indexOf("mozilla/4.8 ") != -1);
var is_netscape_6 = (browser_userAgent.indexOf("netscape6/") != -1);
var is_netscape_6_up = (browser_userAgent.indexOf("netscape6/") != -1) ||
	(browser_userAgent.indexOf("netscape/7") != -1);
var is_netscape_6_01 = (browser_userAgent.indexOf("netscape6/6.01") != -1);
var is_netscape_7_0 = (browser_userAgent.indexOf("netscape/7.0") != -1);

var is_konqueror = (browser_userAgent.indexOf("konqueror") != -1);

var is_safari = (browser_userAgent.indexOf("safari") != -1);

var is_firefox = (browser_userAgent.indexOf("Firefox") != -1); 

//http://www.dynamicdrive.com/dynamicindex9/browsersniffer.htm
/*Variables from the script
The script returns a set of browser variables (Below are live results dependant on your browser type): 

var returns Description 
   
ie 1 Internet Explorer 4+ and IE-based third-party browsers. You can also be more specific:  
ie4 0 ... Internet Explorer 4 only.  
ie5 1 ... Internet Explorer 5 or 6.  
ie6 0 ... Internet Explorer 6 only.  

  
ns4 0 Netscape 4  

  
ns6 0 Gecko and KDE-based browsers - which includes Netscape 6 and 7, Mozilla, Konqueror and Safari. You can also identify smaller groups within this: 
ns7 0 ... Netscape 7.  
mz7 0 ... any gecko browser except Netscape. This is principally designed to identify Mozilla's own builds from Version 0.6 onwards, but it also returns true for any other non-netscape gecko browser.  
kde 0 ... Konqueror, from KDE 2.2 onwards.  
saf 0 ... Safari. This variable will identify Safari irrespective of which browser it's set to identify as.  

  
op5 0 Opera 5  
op6 0 Opera 6  
op7 0 Opera 7 
These variables will identify Opera irrespective of which browser it's set to identify as. 
 

Underpinning these is a safety variable, for protecting legacy browsers:

  
exclude 0  

There are also three OS variables: 

   
win 1 Windows  
mac 0 Mac OS  
lin 0 Linux, or anything else  

and you can query a lower-case version of the user agent string:

  
agt mozilla/4.0 (compatible; msie 5.5; windows nt 5.0; .net clr 1.0.3705)  

The sniffer variables are global, and therefore available to any other scripts on the same page. They allow you to code for or exclude specific browsers, eg: 

if (mac&&ie5) { ... internet explorer 5 on a mac ... }
if (!ns4) { ... not netscape 4 ... }
if (win&&(op5||op6)) { ... a windows version of opera 5 or 6 ... }
if (ie5||ns6||op7) { ... ie5+, gecko, kde or opera 7 ... }
Remember that some browsers return true for more than one variable: 

Explorer 6 returns true for (ie6) and also for (ie) 
Explorer 5 or 6 return true for (ie5) and also for (ie) 
Explorer 4 returns true for (ie4) and also for (ie) 
Konqueror returns true for (kde) and also for (ns6) 
Safari returns true for (saf) and also for (ns6) 
All Gecko-based browsers which aren't Netscape return true for (mz7) and also for (ns6) 
The exclude variable returns true for all unspecified browsers. This is very useful for protecting them from scary DHTML, eg: 

if (!exclude) { ... modern browsers only ... }
You may find it necessary to use a combination of expressions to get to the browser you need, eg: 

if (!exclude) {
    if (ns6||op7) { ... gecko, KTHML or Opera 7 ... }
    else if (ie5) { ... internet explorer 5+ ... }
    else { ... any other dhtml browser ... }
    http://www.dynamicdrive.com/dynamicindex9/browsersniffer.htm
*/

var exclude=1;
var agt=navigator.userAgent.toLowerCase();
var win=0;var mac=0;var lin=1;
if(agt.indexOf('win')!=-1){win=1;lin=0;}
if(agt.indexOf('mac')!=-1){mac=1;lin=0;}
var lnx=0;if(lin){lnx=1;}
var ice=0;
var ie=0;var ie4=0;var ie5=0;var ie6=0;var com=0;var dcm;
var op5=0;var op6=0;var op7=0;
var ns4=0;var ns6=0;var ns7=0;var mz7=0;var kde=0;var saf=0;
if(typeof navigator.vendor!="undefined" && navigator.vendor=="KDE"){
	var thisKDE=agt;
	var splitKDE=thisKDE.split("konqueror/");
	var aKDE=splitKDE[1].split("; ");
	var KDEn=parseFloat(aKDE[0]);
	if(KDEn>=2.2){
		kde=1;
		ns6=1;
		exclude=0;
		}
	}
else if(agt.indexOf('webtv')!=-1){exclude=1;}
else if(typeof window.opera!="undefined"){
	exclude=0;
	if(agt.indexOf("opera/5")!=-1||agt.indexOf("opera 5")!=-1){op5=1;}
	if(agt.indexOf("opera/6")!=-1||agt.indexOf("opera 6")!=-1){op6=1;}
	if(agt.indexOf("opera/7")!=-1||agt.indexOf("opera 7")!=-1){op7=1;}
	}
else if(typeof document.all!="undefined"&&!kde){
	exclude=0;
	ie=1;
	if(typeof document.getElementById!="undefined"){
		ie5=1;
		if(agt.indexOf("msie 6")!=-1){
			ie6=1;
			dcm=document.compatMode;
			if(dcm!="BackCompat"){com=1;}
			}
		}
	else{ie4=1;}
	}
else if(typeof document.getElementById!="undefined"){
	exclude=0;
	if(agt.indexOf("netscape/6")!=-1||agt.indexOf("netscape6")!=-1){ns6=1;}
	else if(agt.indexOf("netscape/7")!=-1||agt.indexOf("netscape7")!=-1){ns6=1;ns7=1;}
	else if(agt.indexOf("gecko")!=-1){ns6=1;mz7=1;}
	if(agt.indexOf("safari")!=-1 || (typeof document.childNodes!="undefined" && typeof document.all=="undefined" && typeof navigator.taintEnabled=="undefined")){mz7=0;ns6=1;saf=1;}
	}
else if((agt.indexOf('mozilla')!=-1)&&(parseInt(navigator.appVersion)>=4)){
	exclude=0;
	ns4=1;
	if(typeof navigator.mimeTypes['*']=="undefined"){
		exclude=1;
		ns4=0;
		}
	}
if(agt.indexOf('escape')!=-1){exclude=1;ns4=0;}
if(typeof navigator.__ice_version!="undefined"){exclude=1;ie4=0;}


function get_system(){
  var result = 'Indtermin';
  if (win) {
    result = "Windows";
  } 
  if (mac) {
    result = "Macintosh";
  }
  if (lnx) {
    result = "Linux";
  }
  return result;
}

function get_browserkind(){
  var result = 'Indtermin';
  if (ie) {
    result = "Internet Explorer";
  }
  if (ns6) {
    result = "Netscape";
  }
  if (saf) {
    result = "Safari";
  }
  return result;
}


function testCookies() { 
 var exp = new Date(); 
 var accept;
 exp.setTime(exp.getTime() + 1800000); 
 // first write a test cookie 
 setCookie("IA_Cookies", "yes", exp, false, false, false); 
 if (document.cookie.indexOf('IA_Cookies') != -1) { 
   accept = true; 
 } 
 else { 
   accept = false; 
 } 
 // now delete the test cookie 
  exp = new Date(); 
  exp.setTime(exp.getTime() - 1800000); 
  setCookie("IA_Cookies", "cookies", exp, false, false, false); 
  return accept;
 }

function setCookie(name, value, expires, path, domain, secure) { 
 var curCookie = name + "=" + escape(value) + 
    ((expires) ? "; expires=" + expires.toGMTString() : "") + 
    ((path) ? "; path=" + path : "") + 
    ((domain) ? "; domain=" + domain : "") + 
    ((secure) ? "; secure" : ""); 
 document.cookie = curCookie; 
}

var acceptsCookies = false;
if (saf) {
  acceptsCookies = testCookies();
} else { 
  if(document.cookie == '') {
    document.cookie = 'IA_Cookies=yes'; 
    if(document.cookie.indexOf('IA_Cookies=yes') != -1) {
        acceptsCookies = true; 
    }
  } else {
    acceptsCookies = true;
  }
}
