<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * mas_droit_groupes
 * @package Jade
 * @subpackage mas
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 * @todo language file
 */ 
    function ignition(&$fm) {
        $the_form = new FormList(
          "select acces_group,
                  description,
                  site_user_type,
                  name
           from cms.acces_group
           order by description", "acces_group", get_constant("DATABASE_MAIN"));

        $the_form->set_title("<big>Gestion des droits par groupe</big>");
        $the_form->hide("acces_group");
        $the_form->label("description", "Groupe");

        $fm->add_form('list_acces_groups', $the_form);
        $fm->register_zoom('zoom_acces_group', 'list_acces_groups', 'init_zoom_acces_group');
    }

    function init_zoom_acces_group(&$fm) {
        $the_form = new formZoom(
          "select  acces_group,
                  description,
                  site_user_type,
                  name
           from cms.acces_group
           order by description", "acces_group", get_constant("DATABASE_MAIN"));

        $the_form->set_title("<big>Groupe</big>");
        $the_form->no_navigate();
        $the_form->hide("acces_group");
        $the_form->required("description");
        $the_form->label("description", "Groupe");

        $fm->add_form('zoom_acces_group', $the_form);
        $fm->link_zoom('zoom_acces_group');

        $fm->register_detail('liste_acces_rights', 'zoom_acces_group',
          "acces_group", 'init_liste_acces_rights');
        $fm->register_detail('liste_acces_member', 'zoom_acces_group',
          "acces_group", 'init_liste_acces_member');
    }

    function init_liste_acces_rights(&$fm){
        $the_form = new formlist(
          "select acces_group,
             action,
             acces_rights
           from cms.acces_rights
           order by action", "action", get_constant("DATABASE_MAIN"));

        $the_form->set_title("<big>Liste des droits d'access</big>");
        $the_form->pick_list("acces_rights",
          array("Aucun" => "n", "Lecture" => "r", "criture" => "w"));
        $the_form->pick_list("action", "cms.v_pl_menu_action");
        $the_form->hide("acces_group");
        $the_form->no_save();

        $fm->add_form('liste_acces_rights', $the_form);
        $fm->link_detail('liste_acces_rights');
        $fm->register_zoom('zoom_acces_rights', 'liste_acces_rights', 'init_zoom_acces_rights');
    }

    function init_zoom_acces_rights(&$fm){
        $the_form = new formzoom(
          "select acces_group,
             action,
             acces_rights
           from cms.acces_rights
           order by action", "action", get_constant("DATABASE_MAIN"));

        $the_form->set_title("<big>Droits d'access</big>");
        $the_form->use_parent_where();
        $the_form->no_navigate();
        $the_form->ro_save("action");
        $the_form->pick_list("acces_rights",
          array("Aucun" => "n", "Lecture" => "r", "criture" => "w"));
        $the_form->defaut("acces_rights", "w");
        $the_form->hide("acces_group");
        $the_form->pick_listfunction("action", "pl_action");
        
        $fm->add_form('zoom_acces_rights', $the_form);
        $fm->link_zoom('zoom_acces_rights');
        sset('fm', $fm);
    }


    function init_liste_acces_member(&$fm){
        $the_form = new formlist(
          "select acces_group,
             site_user
           from cms.acces_member
           order by site_user", "site_user", get_constant("DATABASE_MAIN"));

        $the_form->set_title("<big>Liste des utilisateurs</big>");
        $the_form->hide("acces_group");
        $the_form->pick_list("site_user", "cms.v_pl_site_user");
        $the_form->no_save();

        $fm->add_form('liste_acces_member', $the_form);
        $fm->link_detail('liste_acces_member');
        $fm->register_zoom('zoom_acces_member', 'liste_acces_member', 'init_zoom_acces_member');
    }
    
    function init_zoom_acces_member(&$fm){
        $the_form = new formzoom(
          "select acces_group,
             site_user
           from cms.acces_member
           order by site_user", "site_user", get_constant("DATABASE_MAIN"));

        $the_form->set_title("<big>Utilisateur</big>");
        $the_form->no_navigate();
        $the_form->use_parent_where();
        $the_form->no_save();
        $the_form->ro_save("site_user");
        $the_form->hide("acces_group");
        $the_form->pick_listfunction("site_user", "pl_site_user");

        $fm->add_form('zoom_acces_member', $the_form);
        $fm->link_zoom('zoom_acces_member');
        sset('fm', $fm);
    } 

  function pl_site_user(){
    $fm = sget('fm');
    return sql2arrayselect("cms.v_pl_site_user", 
    "where code not in (select site_user from cms.acces_member " . 
    $fm->_forms[$fm->_forms["zoom_acces_member"]["form"]->_parent]["form"]->_sql->get_modifie_where() .
    ")", get_constant("DATABASE_MAIN")); 
  }
  
  function pl_site_user_ro(){
    return sql2arrayselect("cms.v_pl_site_user", "", get_constant("DATABASE_MAIN")); 
  }
  
  function pl_action(){
    $fm = sget('fm');
    return sql2arrayselect("cms.v_pl_menu_action", 
    "where code not in (select action from cms.acces_rights " . 
    $fm->_forms[$fm->_forms["zoom_acces_rights"]["form"]->_parent]["form"]->_sql->get_modifie_where() .
    ")", get_constant("DATABASE_MAIN")); 
  }

  function pl_action_ro(){
    return sql2arrayselect("cms.v_pl_menu_action", "", get_constant("DATABASE_MAIN")); 
  }
?>