<?php 
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * mas_action
 * @package Jade
 * @subpackage mas
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */ 
  function ignition(&$fm) {
    $fm->first_time_action("recherche_action", "url_find");
    $the_form = new formrecherche(
      "select root, 
         action,
          label,
          content
       from cms.v_cat_action_menu
       order by action", "action", get_constant("DATABASE_MAIN"));

    $the_form->set_title("<big>Gestion des actions</big>");
    $the_form->g_custom("init_menus", "Rafrachir les menus", "Rafrachir les menus");
    $the_form->pick_list("root", "v_pl_menus");
    $the_form->search_equal("root");
    $the_form->no_criteria("root");
    $the_form->html_class("root", "quickFilter");
    $the_form->width("root", "");
    $the_form->quick_filter("root");
    $the_form->set_property(array("content", "label"), "maxlen", 500);
    $the_form->activesearchsibling = "tree_faq";
    
    $the_form->required(array("active", "a_active"), false);
    $the_form->set_label_report("report_list_action", get_label("btn_repport"));
    $the_form->set_title_report("report_list_action", "Liste des actions");
    $fm->add_form('recherche_action', $the_form);   
    $fm->register_searchsibling('list_action', 'recherche_action', "faq", 'init_list_action', "Liste"); 
    $fm->register_searchsibling('level_action', 'recherche_action', "faq", 'init_level_action', "Liste hirarchique"); 
    $fm->register_searchsibling('tree_faq', 'recherche_action', "faq", 'init_tree_faq', "Arborescence");
    $fm->register_report("report_list_action", "recherche_action", "list_action", 'init_report_list_action');
 }
 
 function init_menus(&$fm) {
   sset("reinitmenu", true);
   $url = get_urlmd5(update_url_query(batir_href(gget("action")), "frame"));
   echo "<script>parent.location = '$url';</script>";
 }
 
 function init_level_action(&$fm) {
    $the_form = new FormLevel(
      "select action,
         name,
         label,
         sort_order,
         visible,
         action_type
       from cms.v_cat_action_menu
       order by parent_sort_order, sort_order",
        "action", "parent_action", "cms.action", "action",
         get_prefix_langue()."label", get_constant("DATABASE_MAIN"));

    $the_form->pick_list("action_type", 
       array ( "html" => "html",
               "php" => "php",
               "Sous-menu" => "submenu",
               "Menu" => "menu",
               "url" => "url"
              ));
    $the_form->hide("action");
    $the_form->display_format('visible', "boolicon");
    $the_form->ouinon_value(
      array("a_visible", "a_active", "visible", "active", "site_map", "highlight"), "1", "0");
    
    $fm->add_form('level_action', $the_form);
    $fm->register_zoom('zoom_action', 'level_action', 'init_zoom_action');
    $fm->link_searchsibling('level_action');
  } 
    
 function init_tree_faq(&$fm) {
    $the_form = new formtree(
      "select label
       from cms.v_cat_action_menu
       order by parent_sort_order, sort_order", "action", "parent_action", get_constant("DATABASE_MAIN"));
    
    $fm->add_form('tree_faq', $the_form);
    $the_form->sort_order("parent_sort_order, sort_order");
    $fm->link_searchsibling('tree_faq');
    $fm->register_zoom('zoom_action', 'tree_faq', 'init_zoom_action');
  } 
    
  function init_report_list_action(&$fm) {
    $the_form = new FormListReport(
      "select name, 
        label,
        content
       from cms.v_cat_action_menu
       order by name", "action", get_constant("DATABASE_MAIN"));

    $fm->add_form('report_list_action', $the_form);
    $fm->link_report('report_list_action');
  } 
  
  
 function init_list_action(&$fm) {
    $the_form = new FormList(
      "select action,
         name,
         label,
         sort_order,
         visible,
         parent_action,
         default_action,
         action_type
       from cms.v_cat_action_menu
       order by name", "action", get_constant("DATABASE_MAIN"));

    $the_form->pick_list("action_type", 
       array ( "html" => "html",
               "php" => "php",
               "Sous-menu" => "submenu",
               "Menu" => "menu",
               "url" => "url"
              ));
    $the_form->hide("action");
    $the_form->display_format('visible', "boolicon");
    $the_form->ouinon_value(
      array("a_visible", "a_active", "visible", "active", "site_map", "highlight"), "1", "0");
    
    $fm->add_form('list_action', $the_form);
    $fm->register_zoom('zoom_action', 'list_action', 'init_zoom_action');
    $fm->link_searchsibling('list_action');
  } 
  
  function init_zoom_action(&$fm) {
    $the_form = new formHtml(
      "select action, 
          name, 
          filename, 
          a_filename,
          parent_action,
          root,
          action_tree,
          default_action, 
          a_default_action, 
          sort_order, 
          action_type, 
          label, 
          a_label,
          title,
          a_title,
          header,
          a_header,
          description,
          a_description,
          hint, 
          a_hint, 
          site_map, 
          visible,
          a_visible,
          active, 
          a_active,
          content, 
          a_content,
          image,
          image_over,
          a_image,
          a_image_over, 
          highlight, 
          url, 
          a_url,
          target,
          beginning,  
          ending,
          alternate_path,
          restriction,
          note
       from cms.v_cat_action_menu
       order by name", "action", get_constant("DATABASE_MAIN"));
       
    //$the_form->required($the_form->_fields, false);

    $the_form->no_navigate();
    $the_form->set_title("<big>Menus</big>");
    $the_form->detailed(array(
        "image", 
        "a_image", 
        "image_over", 
        "a_image_over", 
        "icone", 
        "a_icone", 
        "url", 
        "a_url",
        "target",
        "beginning",  
        "ending",
        "alternate_path",
        "restriction",
        "highlight",
		"filename", 
        "a_filename",
		"root"));
    $the_form->no_update(array("action", "action_tree", "root"));
    $the_form->pick_list("action_type", 
       array ( "html" => "html",
               "php" => "php",
               "Sous-menu" => "submenu",
               "Menu" => "menu",
               "url" => "url"
              ));
    $the_form->pick_listedit("note", "v_pl_action_note");
    $the_form->set_property("note", "maxlen", 200);
    $the_form->memo(array("label", "a_label", "title", "a_title", "header", "a_header", "description", "a_description"));
    $the_form->height(array("label", "a_label", "title", "a_title", "header", "a_header", "description", "a_description"), 70);
    $the_form->width(array("label", "a_label", "title", "a_title", "header", "a_header", "description", "a_description"), 300);
    
    $the_form->pick_list("parent_action", "cms.v_pl_parent_action");
    $the_form->pick_list("default_action", "cms.v_pl_action");
    $the_form->pick_list("a_default_action", "cms.v_pl_action");
    $the_form->boolean(array("a_visible", "a_active", "visible", "active", "site_map", "highlight"));
    $the_form->ouinon_value(
      array("a_visible", "a_active", "visible", "active", "site_map", "highlight"), "1", "0");
    $the_form->required(array("action_type", "sort_order"));
    
    $the_form->edithtml(array("content", "a_content"));
    $the_form->use_autoinitialise("parent_action", "autoinaction");
    $the_form->alt_table("cms.action");

    $fm->add_form('zoom_action', $the_form);
    $fm->link_zoom('zoom_action');

  } 
 
 ?>