<?php 
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * cms_utilisateur
 * @package Jade
 * @subpackage cms
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */ 
  function ignition(&$fm) {

   if (gget("action") == 'cms_usparameter') {
      init_zoom_usager($fm);
   }
   else {

    if (gget('action') != 'mas_utilisateur') { // menu master
      $the_where = " where is_master(site_user) = 0";
    }
    $fm->first_time_action("recherche_action", "url_find");
    $the_form = new formrecherche(
      "select site_user,
         last_name,
         first_name,
         site_user_type,
         active,
         email,
         created,
         last_login
       from vz_site_user
       $the_where order by last_name", "last_name");


    $the_form->set_title(get_str("ttl_recherche_usager"));
    $the_form->width(Array("created", "last_login"), get_constant("STANDARD_WIDTH_DATE"));
    
    $the_form->label("created", get_str("lbl_created"));
    
    $the_form->required(array("site_user_type", "site_user", "first_name", "last_name",
      "active", "email"), false);
    
    if (gget('action') == 'cms_usutilisateur') { // menu administrateur
        $the_form->pick_list("site_user_type", $_SESSION["site_user_type_administrator".(get_parametre_systeme("utiliser_superviseur") ? "_SU" : "")]);
    }
    
    if (gget('action') == 'mas_utilisateur') { // menu master
        $the_form->pick_list("site_user_type", $_SESSION["site_user_type_master".(get_parametre_systeme("utiliser_superviseur") ? "_SU" : "")]);
    }
    $the_form->search_picklist("created");
    $the_form->search_picklist("last_login");
    $the_form->search_equal("active");
    $the_form->ouinon_value(array("active"), 1, 0);
    $the_form->pick_list("active", picklist_yesno("1", "0"));
    $the_form->no_highlightreg("active");
    $the_form->no_highlightreg("site_user_type");
    $the_form->calendar(array("created", "last_login"));
    $the_form->display_format(array("created", "last_login"), "shortdate");
    
    $the_form->set_label_report("report_list_usager", get_label("btn_repport"));
    $the_form->set_title_report("report_list_usager", get_str("ttl_repport"));
    
    $fm->add_form('recherche_usager', $the_form);
    $fm->register_detail('list_usager', 'recherche_usager', "site_user", 'init_list_usager');
    $fm->register_report("report_list_usager", "recherche_usager", "list_usager", 'init_report_list_usager');
   }
 }
 
 function init_report_list_usager(&$fm){
    $the_form = new FormListReport("SELECT site_user,
            last_name,
            first_name,
            site_user_type,
            active,
            email,
            created,
            last_login
       FROM site_user
       ORDER BY last_name", "site_user");
    if (gget('action') == 'cms_usutilisateur') { // menu administrateur
        $the_form->pick_list("site_user_type", $_SESSION["site_user_type_administrator".(get_parametre_systeme("utiliser_superviseur") ? "_SU" : "")]);
    } elseif (gget('action') == 'mas_utilisateur') { // menu master
        $the_form->pick_list("site_user_type", $_SESSION["site_user_type_master".(get_parametre_systeme("utiliser_superviseur") ? "_SU" : "")]);
    }
    
    $the_form->display_format(array("created","last_login"), "shortdate");
    $the_form->ouinon_value(array("active"), "1", "0");
    $the_form->display_format("active","ouinon");
    $the_form->label("created", get_str("lbl_created"));
    $fm->add_form('report_list_usager', $the_form);
    
    $fm->link_report('report_list_usager');
 }
 
 function init_list_usager(&$fm) {
    $the_form = new FormList(
      "select site_user,
            last_name,
            first_name,
            site_user_type,
            active,
            email,
            created,
            last_login
       from site_user
       order by last_name", "site_user");

    if (gget('action') == 'cms_usutilisateur') { // menu administrateur
        $the_form->pick_list("site_user_type", $_SESSION["site_user_type_administrator".(get_parametre_systeme("utiliser_superviseur") ? "_SU" : "")]);
    }
    
    if (gget('action') == 'mas_utilisateur') { // menu master
        $the_form->pick_list("site_user_type", $_SESSION["site_user_type_master".(get_parametre_systeme("utiliser_superviseur") ? "_SU" : "")]);
    }
    $the_form->display_format('active', "boolicon");
    $the_form->display_format(array("created", "last_login"), "shortdate");
    $the_form->label("created", get_str("lbl_created"));
    $the_form->optional_search(array("email",
            "created",
            "last_login"));
    $the_form->ouinon_value(array("active"), 1, 0);

    
    $fm->add_form('list_usager', $the_form);
    $fm->link_detail('list_usager');
    $fm->register_zoom('zoom_usager', 'list_usager', 'init_zoom_usager');
  } 
  
  function init_zoom_usager(&$fm) {
    $the_form = new utilisateur_zoom(
      "select site_user,
            first_name,
            last_name,
            password_temp,
            password_valid_until,
            
            " .
            get_language_order("title")
            . ", gender,
            language,
            
            email,
            signature,
            confirmed,
            phone1,
            fax,
            web_site, 
            
            active,
            site_user_type,
            login_count,
            created,
            last_login,
            
            internal_note,
            note,
            question,
            password,
            key
       from vz_site_user
       order by last_name", "site_user");


    $the_form->site_user = get_cargo("user_name");
    $the_form->set_title(get_str("ttl_zoom_usager"));
    
    $the_form->hide(array("question", "password", "key"));
    $the_form->defaut("site_user_type", "UI");
    $the_form->defaut("question", "aucune");
    $the_form->defaut("language", "F");
    
    $the_form->defautfunction("key", "get_new_key");
    $the_form->defautfunction("password_temp", "get_new_password");
    $the_form->defautfunction("password", "get_new_password_md5");
    $the_form->defautfunction("password_valid_until", "get_valid_until");
    $the_form->display_format(array("password_valid_until"), "datetime");
    
      
    if (gget('action') == 'cms_usparameter') { // menu parametre standard
        $the_form->hide(array("site_user_type", "internal_note", "password_temp", "login_count",
                              "last_login", "active", "confirmed", "note"));
        $the_form->no_insert();
        $the_form->no_delete();
    } 

    if (gget('action') == 'cms_usutilisateur') { // menu administrateur
        $the_form->hide(array("internal_note"));
        $the_form->pick_list("site_user_type", $_SESSION["site_user_type_administrator".(get_parametre_systeme("utiliser_superviseur") ? "_SU" : "")]);
    }
    
    if (gget('action') == 'mas_utilisateur') { // menu master
        $the_form->pick_list("site_user_type", $_SESSION["site_user_type_master".(get_parametre_systeme("utiliser_superviseur") ? "_SU" : "")]);
    }

    $the_form->required(array("site_user_type", "site_user", "first_name", "last_name", "email"));
    $the_form->alt_table("cms.site_user");

    
    $the_form->no_navigate();
    $the_form->insert_spacer_before(get_prefix_langue()."title");
    $the_form->insert_spacer_before("email");
    $the_form->insert_spacer_before("active");
    $the_form->insert_spacer_before("internal_note");
    $the_form->no_update(array("question_count",
            "login_count", "password_temp",
            "confirmed",
            "created",
            "last_login",
            "password_valid_until"));
    $the_form->pick_list("gender", "cms.v_pl" . get_language() . "_gender");
    $the_form->width("gender", 100);
    $the_form->pick_list("language", "cms.v_pl" . get_language() . "_language");
    $the_form->width("language", 100);

    $the_form->ro_save("site_user");
    $the_form->ouinon_value(array("active"), "1", "0");
    $the_form->boolean(array("active"));
    $the_form->memo(array("note", "internal_note", "signature"));
    $the_form->height(array("note", "internal_note", "signature"), 50);
    $the_form->display_format(array("created", "last_login", 
       "confirmed"), "shortdate");
    $the_form->label("created", get_str("lbl_created"));

    $custom_js = "var strSignature; var strName = forme.fld_first_name.value+' '+ forme.fld_last_name.value;var strTitle = (forme.fld_".get_prefix_langue()."title.value !='')? '\\n'+forme.fld_".get_prefix_langue()."title.value :'';var strEmail = (forme.fld_email.value !='')? '\\n'+forme.fld_email.value : ''; var strPhone = (forme.fld_phone1.value!='')? '\\n'+forme.fld_phone1.value : ''; forme.fld_signature.value= strName+strTitle+strEmail+strPhone;";
    
    $the_form->boutonjs_title("signature", get_str('btn_generer_signature'));
    $the_form->boutonjs_icon("signature", "generer.gif");
    $the_form->boutonjs("signature", $custom_js);
    
    if ((gget('action') == 'mas_utilisateur') || (gget('action') == 'cms_usutilisateur')) { // menu master ou administrateur
      $the_form->set_title(get_str("ttl_zoom_usager_alt"));
   }

   if (gget("action") == 'cms_usparameter') {
      $the_form->_index = get_cargo("user_name");
   }

   $fm->add_form('zoom_usager', $the_form);

   if (gget("action") != 'cms_usparameter') {
     $fm->link_zoom('zoom_usager');
   }

  }

  function get_new_password($username = ""){
    $new_password = substr(sha1($username . "new-pass" . date("ms") . ia_rand(10000,90000)), 1, 10);
    sset("new_password", $new_password);
    return $new_password;
  }
  function get_new_password_md5($username = ""){
    return md5(sget("new_password"));    
  }
  
  function get_valid_until(){
    return preg_replace("/-/", "/", addate(7, null));
  }
?>
