<?php 
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * cms_system
 * @package Jade
 * @subpackage cms
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
  function ignition(&$fm) {
    $the_form = new system_zoom(
      "select system_parameters,
         institution_name,
         department,
         agent,
         email,
         time_zone,
         theme, " .
            get_language_order("welcome_message")
            . ",
         allow_login,
         user_acceptance,
         domain

       from cms.v_cat_system_parameters
       order by system_parameters", "system_parameters");

    $the_form->set_title(get_str("title"));
    
    $the_form->insert_spacer_before(time_zone);
    $the_form->insert_spacer_before(theme);
    $the_form->insert_spacer_before(allow_login);
    $the_form->no_navigate();
    $the_form->no_insert();
    $the_form->no_delete();
    $the_form->alt_table("system_parameters");
    $the_form->hide("system_parameters");
    
    $skin = sget("skin");
    $skin_list = $skin->get_skin_array();
    while ( list($index, $subarray) = each($skin_list) ) {
       $skin_array[ucfirst(str_replace("_", " ", $subarray["label"]))] = $subarray["name"];
    }
    $the_form->pick_list("theme", $skin_array);
    $the_form->pick_list("time_zone", "v_pl" . get_language() . "_time_zone");
    $the_form->pick_list("user_acceptance", "v_pl" . get_language() . "_user_acceptance");
    $the_form->boolean(array("allow_login"));
    $the_form->ouinon_value(array("allow_login"), "1", "0");
    $the_form->required(array("theme", "language", "a_language"));
    $the_form->memo("welcome_message");
    $the_form->height("welcome_message", 50);
    $the_form->memo("a_welcome_message");
    $the_form->height("a_welcome_message", 50);

    $the_form->label("language", get_str("lbl_language"));
    $the_form->label("a_language", get_str("lbl_a_language"));
    $the_form->label("department", get_str("lbl_department"));
    $the_form->label("allow_login", get_str("lbl_allow_login"));
    $the_form->label("user_acceptance", get_str("lbl_user_acceptance"));
    
    $the_form->set_index(1);
    
    $fm->add_form('zoom_systeme', $the_form);
 }
?>