<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * cms_plan
 * @package Jade
 * @subpackage cms
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
function show(){ 
  if (isloged() && get_cargo("user_actions"))
    $restricted_where = "or action in (" . get_cargo("user_actions") . ")";
  $where_sup = (!subscription_avalable() ? " and name <> 'cms_inscription'" : "")
    .(isloged() ? " and name <> 'cms_connexion'": " and name <> 'cms_deconnexion'");
  $rs = selectsql("select action, name, label, coalesce(a_label, '<font color=red>*</font>' || label) as a_label 
     from cms.action 
     where (action not in (select action from cms.acces_rights)
     $restricted_where)
     and site_map = 1 $where_sup  and " . get_prefix_langue() . "active = 1 and name = 'main'
     order by sort_order
		 ", get_constant("DATABASE_MAIN"));
  $lehtml = "<table border=\"0\" width=100%>";
  while (list ($index, $subarray) = each($rs) ) {
    $lehtml .= show_menu($subarray["action"], $subarray["name"], $subarray[get_prefix_langue()."label"], 
      0, $restricted_where, $where_sup);
  }
  $lehtml .=  "</table>";
  echo_box($lehtml, "none", get_str("title"));
} 

// Function appelee de facon recursive pour l'affichage des menu et des sous menu dans le plan du site
// $menu_action = action menu
// $menu_title = Titre du menu (utilise "subarray['titre']" pour les sous menu)
// $i = Indicateur du niveau traite (protection contre boucle sans fin et indentation)
function show_menu($parent, $menu_action, $menu_title, $level, $restricted_where, $where_sup) {
  $rs = selectsql("select hint, a_hint, action, name, label, coalesce(a_label, '<font color=red>*</font>' || label) as a_label, action_type, alternate_path 
     from cms.action 
     where site_map = 1
     and parent_action = $parent
     and action <> $parent  and " . get_prefix_langue() . "active = 1
     and (action not in (select action from cms.acces_rights)
     $restricted_where) $where_sup
     order by sort_order", get_constant("DATABASE_MAIN"));
  if ($level == 0)
    $level++;
  else
    $classname = "class=\"siteplan\"";
  if ($rs) {
	  $str.= "<tr><td width=5>&nbsp;</td><td>";
	  $str.= "<table $classname width=100%>";
	  while (list ($index, $subarray) = each($rs) ) {
	    if ($subarray["action_type"] != "separator") {
	      if ($subarray["action_type"] == "submenu") {
	        $str.= "<tr><td colspan=2><b>" . $subarray[get_prefix_langue()."label"] . "</b></td></tr>";
	        $str.= show_menu($subarray["action"], $subarray["name"], 
	          $subarray[get_prefix_langue()."label"], $level, $restricted_where, $where_sup);
	      } else {
	        if (stripslashes($subarray[get_prefix_langue().'hint']) != "" && stripslashes($subarray[get_prefix_langue().'hint']) != stripslashes($subarray[get_prefix_langue().'label'])) {
	          $title = "title=\"" . stripslashes($subarray[get_prefix_langue().'hint']) . "\"";
	        } else {
	          $title = "";
	        }
	        $url= update_url_query(batir_href_menu($subarray['name'], 
	            $subarray['alternate_path'], 
	            $subarray['action_type']), "frame");
	        $str.= "<tr><td colspan=2><img src=\"" . sget("image_dir") . "icon_menutop.gif\" alt=\"\" width=\"6\" height=\"6\" border=\"0\">
	  &nbsp;<a href=\"$url\" $title target=\"_top\">" .
	          $subarray[get_prefix_langue()."label"] . "</a></td></tr>";
	      }
	    }
	  }
	  $str.= "</table>";
	  $str.= "</td></tr>";
	}
  return $str;
}
 ?>