<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * cms_oublimotpasse
 * @package Jade
 * @subpackage cms
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */

  function init_wizard(&$fm){
    $fm->set_title("", get_str("title"));
    $fm->register_wizard('oublimotpasse_intro', 'ignition');
    $fm->set_back("oublimotpasse_intro", "no");
    $fm->set_next("oublimotpasse_intro", "save");
    $fm->set_exit('oublimotpasse_intro', "oublimotpasse_intro");
    $fm->is_part_of_summary('oublimotpasse_intro', false);
    $fm->set_title('oublimotpasse_intro', get_str("ttl_oublimotpasse_intro"));
    
    $fm->register_wizard('oublimotpasse_email', 'init_email');
    $fm->set_back("oublimotpasse_email", "no");
    $fm->set_next("oublimotpasse_email", "no");
    $fm->set_exit('oublimotpasse_email', "oublimotpasse_email");
    $fm->is_part_of_summary('oublimotpasse_email', false);
    $fm->set_title('oublimotpasse_email', get_str("ttl_oublimotpasse_email"));

    $fm->register_wizard('zoom_password', 'init_zoom_password');
    $fm->set_back("zoom_password", "no");
    $fm->set_next("zoom_password", "save");
    $fm->set_exit("zoom_password", "zoom_password");
    $fm->is_part_of_summary('zoom_password', false);
    $fm->set_title('zoom_password', get_str("ttl_zoom_password"));
    $fm->set_comment('zoom_password', get_str("cmt_zoom_password"));

    $fm->register_wizard('conclusion', 'init_conclusion');
    $fm->is_conclusion('conclusion');
    $fm->set_back("conclusion", "no");
    $fm->set_next("conclusion", "no");
    $fm->set_exit('conclusion', "conclusion");
    $fm->set_title('conclusion', get_str("ttl_conclusion"));

  }
    
  function init_conclusion(&$fm) {
    $the_form = new oublimotpasse_conclusion();
    $the_form->set_content(get_str("cnt_conclusion"));
    $fm->add_form('conclusion', $the_form);
  }
  
  function ignition(&$fm) {
    $the_form = new oublimotpasse_intro(
       "SELECT email 
       FROM cms.site_user 
       ORDER BY site_user", "site_user");
    $the_form->no_delete();
    $the_form->no_insert();
    $the_form->no_navigate();
    $the_form->label("email", get_str("lbl_email"));
    $the_form->set_compare("email");
    $the_form->hide_footer();
    $the_form->html_attribut("email", "nowrap");
    $fm->add_form('oublimotpasse_intro', $the_form);
  }
  
  function init_email(&$fm) {
    $the_form = new formroot();
    $the_form->set_content(get_str("cnt_oublimotpasse_email"));
    $fm->add_form('oublimotpasse_email', $the_form);
  }
  
  function init_zoom_question(&$fm) {
    $the_form = new oublimotpasse_question(
      "SELECT site_user,
              key
       FROM cms.site_user
       ORDER BY 1", "site_user");
       
    $the_form->no_navigate();
    $the_form->no_delete();
    $the_form->no_insert();
    $the_form->no_update("site_user"); 

    $the_form->hidden("key");
    $the_form->hide_footer();
    
    $fm->add_form("zoom_question", $the_form);
  }
  
  
  function init_zoom_password(&$fm){    
    $the_form = new oublimotpasse_password(
      "SELECT site_user,
              password,
              key
       FROM cms.site_user
       ORDER BY 1", "site_user");
    $the_form->no_navigate();
    $the_form->no_delete();
    $the_form->no_insert();
    $the_form->no_update("site_user");  
    $the_form->password_confirm("password");
    $the_form->label("password", get_str("lbl_password"));
    $the_form->set_compare("password");
    $the_form->hidden("key");
    $fm->add_form('zoom_password', $the_form);
  }

?>