<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * cms_inscription zoom
 * @package Jade
 * @subpackage cms
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
class inscription_usager extends FormZoom {
  function url_insert(&$fm){
    $result = $this->insert($fm);
    if($result!=""){
      $this->restore_insert($fm, $result);
    } else {
      $complete_name .= pget('fld_first_name');
      $complete_name .= ", ".pget('fld_last_name');
      
      $this->send_subscription_confirmation(pget('fld_site_user'), 
                                            $complete_name, 
                                            pget('fld_email'), 
                                            pget('fld_key'));
/*
* @todo language file
*/                                            
      $msg = (is_primary_language() ? ("Vous recevrez un courriel vous invitant  confirmer votre inscription.  Sur rception de votre confirmation votre inscription dans " . get_constant("APPLICATION_NAME") . "sera complte.") :
                             ("You will be receiving an e-mail asking you to confirm your registration.  Once system has received your confirmation, you will be registered in " . get_constant("APPLICATION_NAME") . ".")) ;
      echo_box($msg);
    }
  }
  
  /**
  * Prepare the mail information to send
  */
  function send_subscription_confirmation($site_user, $complete_name, $email, $key){
    $url = update_url_query($this->_url,"mode","activated_account");
    $url = update_url_query($url,"objet","zoom_usager");
    $url = update_url_query($url,"frame","");
    $url = update_url_query($url,"site_user",$site_user);
    $url = update_url_query($url,"key",$key);
    $url = get_urlmd5($url);
    $subject = (is_primary_language() ? "Confirmation de l'inscription  " : "Confirmation of registration in ") . get_constant("APPLICATION_NAME");
    
    if(is_primary_language()){
    $msg = "Bonjour, ".$complete_name.".<br><br>
           Vous venez de vous inscrire au logiciel en ligne " . get_constant("APPLICATION_NAME") . ".<br>
           Votre nom d'utilisateur est : <b>$site_user</b>.<br>
           Veuillez cliquer sur le lien suivant <a href=\"$url\">suivant</a> pour confirmer votre inscription
            au service de rservation d'espaces.";
    } else{
    $msg = "Hello  ".$complete_name."<br><br>
           You have just registered for the on-line " . get_constant("APPLICATION_NAME") . " service.<br>
           Your user name is: <b>$site_user</b>.<br>
           Please click on the following <a href=\"$url\">link</a> to confirm your registration in the room reservation service.";
    
    }
    $sender_name = get_constant("CLIENT_NAME");
    $sender_email = get_constant("WEBMASTER");
    $receiver_name = $complete_name;
    $receiver_mail = $email;
    $msg = wrap_mail_body($msg);
    send_mail($sender_name, $sender_email, "", $receiver_mail, $subject, $msg, 0, 'html');
  }
  
  /**
  *
  */
  function url_activated_account(&$fm){
    $activated = 0;
    $rs = selectsql("SELECT site_user 
            FROM site_user 
            WHERE site_user = '".trim(gget('site_user')). "' AND key = '".trim(gget('key'))."'");
    
    if($rs != "")
      $activated = $this->activate_member($rs);
    
    if($activated == 1){
      $msg = is_primary_language() ? "Compte activ." : "Account activated.";
    } else {
      $rs = selectsql("SELECT agent, email
          FROM system_parameters WHERE system_parameters = 1"); 
      $msg = is_primary_language() ? "Compte non activ.&nbsp;&nbsp;Votre compte sera activ par votre administrateur.&nbsp;&nbsp;Pour communiquer avec lui : <a href=\"mailto:" . $rs[0]["email"] . "\">" . $rs[0]["agent"] . "</a>."
          : "Account not activated.";
    }
    echo_box($msg);
  }
  
  function activate_member($site_user){
    $sql = "SELECT udf_activate_user('".$site_user."')";
    return selectsql($sql);
  }

}


?>