<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * cms_inscription
 * @package Jade
 * @subpackage cms
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
  function ignition(&$fm) {
    if(gget('mode') == "activated_account"){
      $fm->first_time_action("zoom_site_user", "url_activated_account");
    } else {
      $fm->first_time_action("zoom_site_user", "url_add");
    }
    
    $the_form = new inscription_usager("SELECT
            site_user,
            first_name,
            last_name,
            password," .
            get_language_order("title")
            . ", gender,
            language,
            email,
            phone1,
            fax,
            question,
            answer,
            key,
            site_user_type
          FROM cms.site_user 
          ORDER BY 1", "site_user");  
    
    $the_form->no_navigate();
    $the_form->no_delete();
    $the_form->set_title(get_str("title") . "<br>"); 
    
    $the_form->hide(array('question','answer', "site_user_type"));
    $the_form->hidden('key');
    $the_form->set_value('question','interaction');
    $the_form->set_value('answer','interaction');
    $the_form->initializefunction("key", "get_new_key");
    $the_form->defaut("site_user_type", "UI");
    $the_form->set_unique_error_msg("site_user", get_str("msg_registration_rejected"));
    $the_form->insert_spacer_before("site_user");
    $the_form->password_confirm("password");
    
    $the_form->label("password", get_str("lbl_password"));
    
    $the_form->insert_spacer_before(get_prefix_langue()."title");
    $the_form->insert_spacer_before("note");
    
    $the_form->pick_list("language", "cms.v_pl" . get_language() . "_language");
    $the_form->defaut("language", (is_primary_language() ? "F" : "A"));
    $the_form->width("language", 100);
    
    $the_form->pick_list("gender", "cms.v_pl" . get_language() . "_gender");
    $the_form->width("gender", 100);
    
    
    $the_form->memo("note");
    $the_form->height("note", 50);
    
    // validation javascript    
    
    $the_form->set_validation_js("email", "if (!is_email(forme.elements['fld_email'].value))");
    $the_form->msg("email", get_str("msg_email"));
    
    $the_form->set_validation_js("password", "if (!validate_password(forme.elements['fld_password']))");
    $the_form->msg("password", get_str("msg_password"));
    
    $the_form->set_validation_js("site_user", "if (!validate_usager(forme.elements['fld_site_user']))");
    $the_form->msg("site_user", get_str("msg_site_user"));
    
    $the_form->required("first_name");
    
    $the_form->set_buttonlabel_save("Inscrivez-moi");
    //iiii $the_form->set_buttonlabel_save_a("Register Me");
    $fm->add_form("zoom_site_user", $the_form);
    
  }
?>