<?php 
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * cms_faq
 * @package Jade
 * @subpackage cms
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
  function ignition(&$fm) {
    $fm->first_time_action("recherche_faq", "url_find");
    $the_form = new formrecherche(
      "select labelcontent
       from cms.v_liste
       where root = 'faq'
       order by action", "action", get_constant("DATABASE_FAQ"));

    $the_form->set_title("<big>FAQ</big>");
    $the_form->label("labelcontent", "Mots cls");
    $the_form->set_property("labelcontent", "maxlen", 500);
  
    $fm->add_form('recherche_faq', $the_form);
    $fm->register_detail('list_faq', 'recherche_faq', "faq", 'init_list_faq');    
 }
 
 function init_list_faq(&$fm) { 
    $the_form = new listtree(
      "select label,
         content,
         action_type,
         labelcontent
       from cms.v_liste
       order by parent_sort_order, sort_order", "action", "parent_action", get_constant("DATABASE_FAQ"));
    $the_form->no_update();
    $the_form->sort_order("parent_sort_order, sort_order");
    $the_form->outlineclass = "formfaq";
    $fm->add_form('list_faq', $the_form);
    $fm->link_detail('list_faq');
  } 
?>