<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/*
  connection.php
  Identification des usagers
  Le 13 Juin 2002
  Les consultants INTERACTION
*/
/**
 * cms_connexion
 * @package Jade
 * @subpackage cms
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
  function the_url_connexion(){
    return batir_href(gget("action"));
  }
  
  function show_connexion(){
    $usager = pget("usager");
    $motpasse = pget("password");
    if (!get_cargo("visite_salutation_ok")){
      // conserve le dernier nom d'usager fournit par le FORM
      // pour l'initialisation du formulaire
      
      if ($usager && $motpasse) {
        $result = login($usager, $motpasse);
        if ($result == "OK" || $result == "TEMPORAIRE") {
          $conserve_pass = pget("conserve_pass");
          set_cargo("conserve_pass", $conserve_pass);
          if ($conserve_pass == 1) 
            set_cargo("password", $motpasse);
        }
        if ($result == "OK") {
          show_login_confirm();
          set_cargo("open", true);
          sset("reinitmenu", true);
        } elseif ($result == "TEMPORAIRE") {
          set_cargo("visite_url_action", "oublimotpasse");
          set_cargo("visite_feedback", $GLOBALS["cms_connexion"]["msg_temporary_password"]);
          show_login_confirm();
          set_cargo("open", true);
          sset("reinitmenu", true);
        } else {
          set_cargo("visite_feedbackicon", "error");
          set_cargo("visite_feedback", $GLOBALS["cms_connexion"]["msg_absent_user"]);
          show_login();
        }
      } else {
        show_login();
      }
    } else {
      show_login_confirm(false);
      set_cargo("visite_salutation_ok", false);
    }
  }

  function show_login_confirm($redirect = true) {
    
    $action2godirect = get_cargo("visite_url");
    $action2go = get_cargo("visite_url_action");

    if (!isset($_SESSION["cms_sequence"])) {
      $cms_sequence = 1;
    } else {
      $cms_sequence = sget("cms_sequence");
    }
    $cms_sequence++;
    sset("cms_sequence", $cms_sequence);
    $language = get_cargo("language") == "A" ? "a" : "";
    if ($action2godirect != ""){
      set_cargo("visite_salutation_ok", false);
      $redir = $action2godirect;
      $redir = update_url_query($redir, "frame");
      $redir = update_url_query($redir, "langue", $language);
      echo "<script>setTimeout(\"top.location='$redir'\", 2000);</script>";
      set_cargo("visite_url", "");
    } elseif ($action2go != ""){
      set_cargo("visite_salutation_ok", false);
      $redir = batir_href($action2go);
      $redir = update_url_query($redir, "frame");
      $redir = update_url_query($redir, "langue", $language);
      $redir = get_urlmd5($redir);
      echo "<script>setTimeout(\"top.location='$redir'\", 2000);</script>";
    } else {
      set_cargo("visite_salutation_ok", true);
      if ($redirect) {
        if ($action2godirect != "") {
          $redir = $action2godirect;
        } else {
          $redir = batir_href(gget("action"));
          $redir = update_url_query($redir, "frame");
          $redir = update_url_query($redir, "langue", $language);
          $redir = get_urlmd5($redir);
        }
      echo "<script>top.location='$redir';</script>";
      }
      
    } 
    
    set_cargo("visite_url_action", "");
    $parametre_systeme = sget("parametre_systeme");
    copin_include("form/lang/" . gget("action") . "_" 
      . ($language == "" ? get_constant("PRIMARY_LANGUAGE") : get_constant("ALTERNATE_LANGUAGE"))
      . ".php");
    $message_accueil = $parametre_systeme[($language == "" ? "" : "a_") . "welcome_message"];
    if ($message_accueil != "") $message_accueil = "<br><br>" .$message_accueil;
    echo_box($GLOBALS["cms_connexion"]["msg_session_ouverte"]
            . get_cargo("salutation") . ".</b>" . $message_accueil .
             ($action2go != "" ? sprintf($GLOBALS["cms_connexion"]["msg_redirect"], $redir) : "")
              . get_cargo("visite_utilisateurmessage"), "login", 
              "<big>" . $GLOBALS["cms_connexion"]["title"] . "</big>");
  }

  function get_password() {
    return Cookie::get_cookie("conserve_pass") == 1 
      ? Cookie::get_cookie("password") : "";
  }
  function get_conserve_pass() {
    return Cookie::get_cookie("conserve_pass") == 1 ? "checked" : "";
  }

  function show_login() {
    $visite_feedbackicon = get_cargo("visite_feedbackicon");
    echo_box(get_cargo("visite_feedback"), $visite_feedbackicon);
    set_cargo("visite_feedback", "");
    set_cargo("visite_feedbackicon", "");
    ?><!-- debut -->
    <table class="formeZoom" width=100% border=0 cellpadding=0 cellspacing=0>
    <tr>
    <td><table class="formezoomTitle" border=0 cellspacing=0 width=100%><tr>
    <td class="formezoomTitleLeft"></td><td class="formezoomTitleMiddle">
    <big><?php echo $GLOBALS["cms_connexion"]["title"] ?></big>
    </td><td class="formezoomTitleRight"></td></tr></table></td>
  </tr>
  <tr><td align=center><br>
  <form action="<?php echo the_url_connexion() ?>" method="POST">
    <table>  
    <tr>
    <td class="formeZoomCol1"> <?php echo $GLOBALS["cms_connexion"]["user"] ?>&nbsp;&nbsp;</td>
    <td><input style="width:200" type="text"  
                   class="inputbox" 
                   name="usager" 
                   value="<?php $tempusager = get_cargo("tempusager"); echo $tempusager == "" ? 
                            get_cargo("user_name") : 
                            $tempusager; ?>"></td>
  </tr>
    <tr>
    <td class="formeZoomCol1"><?php echo $GLOBALS["cms_connexion"]["pass"] ?>&nbsp;&nbsp;</td>
    <td><input style="width:200" type="password"  
                  class="inputbox" 
                  name="password" 
                  value="<?php echo get_password(); ?>"
                  autocomplete="no"></td>
  </tr>
    <tr>
    <td colspan=2 align=center><input class="checkbox" type="checkbox" 
      name="conserve_pass" value="1" <?php echo get_conserve_pass(); ?>>&nbsp;&nbsp;<?php echo $GLOBALS["cms_connexion"]["optionconserver"] ?>
  </td>
  </tr>
    <tr>
    <td colspan=2 align=center><input class="formeZoombutton" 
                                  type="submit" 
                                  name="btn_submit"
                                  value="<?php echo $GLOBALS["cms_connexion"]["btn_submit"] ?>">
  </td>
  </tr>
    <tr>
    <td colspan=2 align=center><br>
            <?php if (subscription_avalable()) {
             ?><input class="formeZoombutton" 
              type="button"
              name="btn_inscription"
              value="&nbsp;&nbsp;<?php echo $GLOBALS["cms_connexion"]["btn_inscription"] ?>&nbsp;&nbsp;"
              onClick="javascript:window.location.href = '<?php echo batir_href("cms_inscription"); ?>';"
            ><?php } ?>
          <input class="formeZoombutton" 
            type="button"
            name="btn_forget"
            value="&nbsp;&nbsp;<?php echo $GLOBALS["cms_connexion"]["btn_forgot"] ?>&nbsp;&nbsp;"
            onClick="javascript:window.location.href = '<?php echo batir_href("cms_oublimotpasse"); ?>';"
          ><br><br></td>
  </tr>
</table> </form></td></tr>
</table> <!-- fin -->
<?php } ?>