<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * cms_chgpwd zoom
 * @package Jade
 * @subpackage cms
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
/**
 * cms_chgpwd startup
 */
  function ignition(&$fm) {
    $the_form = new chgpwd_zoom(
	    "select site_user,
	            password
	     from cms.site_user
	     order by 1", "site_user");

    $the_form->no_navigate();
    $the_form->no_delete();
    $the_form->no_insert();
    $the_form->no_update("site_user");
    $the_form->label("password", get_str("lbl_password"));

    $the_form->password("password");
    $the_form->set_compare("password");
    $the_form->password_confirm("nouveaumot_passe");
    $the_form->label("nouveaumot_passe", get_str("lbl_nouveaumot_passe"));
    
    $msg = get_cargo("visite_feedback");
    if ($msg != "") {
      $the_form->set_title("<big>" . $msg . "</big>");
    } else {
      $the_form->set_title("<big>" . get_str("title") . "</big>");
    }

    $the_form->set_index(get_cargo("user_name"));
    
    //validation javascript
    $js_script = "if (!validate_password(forme.elements['fld_nouveaumot_passe']))";
    $the_form->set_validation_js('nouveaumot_passe', $js_script);
    $the_form->msg('nouveaumot_passe', get_str("msg_password"));
     
    
    $fm->add_form('zoom_parametre', $the_form);
  }
  
?>