<?php 
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * context
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
//----------GESTION DU COOKIE NECESSAIRE AU LOGIN---------
// 2005/02/17 code revision and cleanup sp
//stabilisation du contexte

$coookie_user_name = Cookie::get_cookie("user_name");
$user_name = get_cargo("user_name");
$visite_user_type = get_cargo("site_user_type");

if(!isset($_SESSION[get_constant("SITE_NAME")]['message_erreur_udf']))
  set_message_erreur_udf();

if(!isset($_SESSION[get_constant("SITE_NAME")]['parametre_systeme'])) {
  set_parametre_systeme();
}

if ($user_name == "" && $coookie_user_name != "") {
    set_cargo("user_name", $coookie_user_name);
} else if ($user_name != "" && $visite_user_type != "") {
  $conserve_pass = get_cargo("conserve_pass");
  if ($conserve_pass == 1) {
    Cookie::set_cookie("user_name", $user_name);
    Cookie::set_cookie("password", get_cargo("password"));
    Cookie::set_cookie("conserve_pass", $conserve_pass);
    Cookie::set_cookie("site_user_type", get_cargo("visite_typeusager"));
  } else {
    Cookie::set_cookie("user_name", "");
    Cookie::set_cookie("password", "");
    Cookie::set_cookie("conserve_pass", $conserve_pass);
    Cookie::set_cookie("site_user_type", "");
  }
}
//------------------------------------------------------


function set_message_erreur_udf() {
    $rs = selectsql("SELECT message,
              description,
              a_description
            FROM
              cms.message");
    $messages = array();
    if (is_array($rs))
	  while (list($index, $subarray) = each($rs)) { 
      $messages[$subarray["message"]]["description"] = $subarray["description"];
      $messages[$subarray["message"]]["a_description"] = $subarray["a_description"];
    }
    sset("message_erreur_udf", $messages);
}

function get_parametre_systeme($param_name) {
  return $_SESSION[get_constant("SITE_NAME")]['parametre_systeme'][$param_name];
}

function set_parametre_systeme($sys = 1){
  $res = selectsql("SELECT allow_login, 
            agent,
            version, 
            email,
            welcome_message, 
            a_welcome_message, 
            logo, 
            a_logo, 
            time_zone, 
            institution_name, 
            theme, 
            department,
            user_acceptance,
            domain
          FROM cms.system_parameters WHERE system_parameters = $sys");
  $rs = $res[0];
  $rs['pg_date_format'] = "YYYY/MM/DD";
  $rs['php_date_format'] = "Y/m/d";
  if (function_exists("app_parametre_systeme")) {
    $app_parametre_systeme = app_parametre_systeme(1);
    if (is_array($app_parametre_systeme))
      $rs = array_merge($rs, $app_parametre_systeme);
  }
  sset('parametre_systeme', $rs);
  return $rs;
}
?>