<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * config_cms.php : Configuration file, cms level
 * @package Jade
 * @subpackage cms
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
// 2005/02/17 code revision and cleanup sp

// comma separated list of development servers
set_constant("DEVELOPMENT_SERVERS", 'developmentServer1,developmentServer2');
set_constant("MACHINE_NAME", get_machine_name());
set_constant("SITE_NAME", preg_replace(array("/[\/\.]/","/(_)$/"), array("_",""), $_SERVER['HTTP_HOST'] . get_url_path()));
set_constant("APPLICATION_NAME","CMS");
set_constant("APPLICATION_DECRIPTION","Gestionnaire de contenu");
set_constant("APPLICATION_DECRIPTION_A","Content Management");
set_constant("APPLICATION_AUTHOR","CompanyName");
set_constant("APPLICATION_GENERATOR","CompanyName");

set_constant("MASTER_LOGO_LINK","");
set_constant("USE_COOKIES_FOR_DEFAULT_SKIN", true);
set_constant("DEFAULT_SKIN", "sk_jade");
set_constant("DEFAULT_SKIN_NO_FRAME", "sk_sans_cadre");
set_constant("DEFAULT_ACTION", "cms_accueil");
set_constant("CONNECT_ACTION", "cms_connexion");
set_constant("AUTO_DEFAULT_ACTION", false);
set_constant("SKIN_MACHINE_LEVEL", false);
set_constant("HORS_SERVICE_ACTION", "<script>top.location='./cms/HorsService.html'</script>");

set_constant("SYSTEM_MAILTO", "");

set_constant("PATH_STATIC","http://". $_SERVER['HTTP_HOST'] . get_url_path());
set_constant("PATH_WORLD","http://". $_SERVER['HTTP_HOST'] . get_url_path());
set_constant("PATH_SECUR","https://". $_SERVER['HTTP_HOST'] . get_url_path());

/** 
  * DEBUG FLAG
  * 0 => no debug information
  * 1 => output url to DEBUG_FILE if <> ""
  */ 
set_constant("DEBUG", 0);
/** 
  * DEBUG_DATABASE FLAG
  * 0 => no debug information
  * 1 => output error only
  * 2 => trace mode
  */ 
set_constant("DEBUG_DATABASE", 0);
set_constant("DEBUG_FILE", is_development_server() ? "erreur.txt" : "");

set_constant("DEBUG_SKINS", false);
set_constant("DEBUG_FIELDS", false);
set_constant("WEBERROR",'erreur@yourserveur.com');

// allow definition of application path.  Paths are separated by ":"
set_constant("APPLICATION_PATH","./:cms/"); 

// maximum d'enregistrement pouvant etre selectionnes
set_constant("MAX_RECORD", 1000);

// paths pour l'aide et les lexiques
set_constant("PATH_HELP", "");
set_constant("PATH_LEXIQUE_FILE", "");

/*  standard width for non regular controls */
//  standard width for dates with calendar button 
set_constant("STANDARD_WIDTH_DATE", 70);
//  standard for time with dropdown or with dropdown and plus button
set_constant("STANDARD_WIDTH_TIME", 55);
set_constant("STANDARD_WIDTH_TIMEPLUS", 80);

/*  masks for calendar control */
set_constant("CALENDAR_VALIDATION_MASK", "YYYY/MM/DD|YYYY-MM-DD");
set_constant("CALENDAR_DISPLAY_MASK", "aaaa/mm/jj");


#set_constant language settings
set_constant("COUNTRY", "ca");
set_constant("PRIMARY_LANGUAGE", "frca");
set_constant("ALTERNATE_LANGUAGE", "enus");
set_constant("ALTERNATE_LANGUAGE_PRESENT", true);

# md5
set_constant("MD5_NOISE","1234");
set_constant("MD5_DATABASE_NOISE", "1234");
?>
