{
  ai.planet
  http://aiplanet.sourceforge.net
  Created by Dave Kerr (kerrd@hotmail.com)
}
unit cAIGod;
{
  Node AIGod

  AIGod is the user-controlled interface
  It is built into the engine, so that the user may interact with the environment
  The graphics engine takes the Position and puts the camera there
}
interface

uses Classes, cAIBaseObject, cAIThings, cAILink, cAICreature, cAIBot,
  cAIPosition;

type

// ============================================================================
AIGod = Class(AIBot)
private
  fViewPosition: AIPosition;      // position of camera
  fViewDestination: AIPosition;   // camera destination
  fViewTarget: AIPosition;        // camera target
  fTrackingSpeed: single;     // how fast the camera moves
  fZoom: single;              // zoom distance to target
  fOffset: single;            // offset from target
  fMode: integer;             // viewing mode


public
  Constructor Create(
    aParent: pointer);
  Destructor Destroy; override;

  function OneLineDisplay: string; override;
  procedure Fuel; override; // add time
end;

// ----------------------------------------------------------------------------

implementation

uses Sysutils, cGlobals, cAIExplosions, cAIVibes;

// ----------------------------------------------------------------------------
Constructor AIGod.Create(
    aParent: pointer);
begin
  inherited Create(aParent);

  fDestination := AIPosition.Create(self);
  fTarget := AIPosition.Create(self);
end;

// ----------------------------------------------------------------------------
Destructor AIGod.Destroy;
begin
  fDestination.Free;
  fTarget.Free;

  inherited Destroy;
end;

// ----------------------------------------------------------------------------
function AIGod.OneLineDisplay: string;
begin
  result := 'God ' + Position.OneLineDisplay;
end;

// ----------------------------------------------------------------------------
procedure AIGod.Fuel;
var
  planeDistance: single;
  heightDistance: single;
begin
  inherited Fuel;

  if Eyes.ValidRight then

  // calculate position of camera target and destination
  case CameraMode of
    camPlanet:      PlanetCamera;
    camTarget:      begin ChaseCamera; Grain := 1.0; end;
    camFind:        begin ChaseCamera; Grain := 1.0; end;
    camAvatar:      AvatarCamera;
    camTrack:       begin TrackCamera; AvatarCamera; end;
    camSatellite:   SatelliteCamera;
  end;

  if ViewPosition.Height < 50 then
    AtmosphereFreeForm.Material.FrontProperties.Diffuse.Alpha :=
      0.98 - (0.008 * Environment.Things.DistanceToNearestSun(ViewPosition))
  else
    AtmosphereFreeForm.Material.FrontProperties.Diffuse.Alpha := 0.25;

  // distance from camera position to destination position
  planeDistance  := ViewPosition.DistanceTo(ViewDestination);
  heightDistance := ViewPosition.DistanceToHeight(ViewDestination.Height);

  Health := 64000;
  Position.Velocity.Zero;

  // move towards destination
  Position.MoveTowards(ViewDestination, sqrt(planeDistance/ViewTrackingSpeed)/Grain*10);
  // move towards height
  Position.MoveTowardsHeight(ViewDestination.Height, sqrt(heightDistance/ViewTrackingSpeed)/Grain*10);
  Position.Velocity.Zero;
  Position.Fuel;

end;

end.

