unit cAIBrainStructures;

interface

uses Classes, cAIBaseObject;

const
  cActionEat = 0;

type

// ----------------------------------------------------------------------------
AIAction = Class(AIBaseObject)
private
  fOrigin: pointer;
  fKind: integer;
  fModifier: single;
  fTarget: pointer;
public
  Constructor Create(
    aParent: pointer;
    aOrigin: pointer;
    aKind: integer;
    aModifier: single;
    aTarget: pointer);

  property Origin: pointer read fOrigin write fOrigin;
  property Kind: integer read fKind write fKind;
  property Modifier: single read fModifier write fModifier;
  property Target: pointer read fTarget write fTarget;

  procedure NilOrigin;
  procedure NilTarget;

  function OneLineDisplay: string; override;
end;

// ----------------------------------------------------------------------------
AIGoal = Class(AIAction)
private
  fAge: integer;
  fFulfilled: boolean;
public
  property Age: integer read fAge write fAge;
  property Fulfilled: boolean read fFulfilled write fFulfilled;

  procedure CopyFrom(aGoal: AIGoal);
end;

// ----------------------------------------------------------------------------
AIGoalList = Class(AIBaseContainer)
private
public
end;

// ----------------------------------------------------------------------------
AIPlan = Class(AIGoal)
private
  fSubGoals: AIGoalList;
public
  property SubGoals: AIGoalList read fSubGoals;
end;

// ----------------------------------------------------------------------------
AIKnowledge = Class(AIBaseObject)
private
public
end;

// ----------------------------------------------------------------------------
AIDesire = Class(AIBaseObject)
private
public
end;

// ----------------------------------------------------------------------------
AIActionList = Class(AIBaseContainer)
private
public
  procedure AddAction(aAction: AIAction);
  procedure NewAction(
    aOrigin: pointer;
    aAction: integer;
    aModifier: single;
    aTarget: pointer);

  function HasNextAction: boolean;
  function NextAction: AIAction;
end;

{
// ----------------------------------------------------------------------------
AISynapse = Class(AIBaseObject)
private
public
end;

// ----------------------------------------------------------------------------
AISynapses = Class(AIBaseContainer)
private
public
end;

// ----------------------------------------------------------------------------
AINeuron = Class(AIBaseObject)
private
  fSuccess: integer;
  fTimes: integer;
  fGrowth: AISynapses;    //owned
  fTouching: AISynapses;  // referenced
public
//  function Truth: AITruth;

end;

// ----------------------------------------------------------------------------
AIMemoryNeuron = Class(AINeuron)
private
  fEvent: AIKnowledge;
public
end;

// ----------------------------------------------------------------------------
AIDesireList = Class(AIBaseContainer)
private
public
end;

// ----------------------------------------------------------------------------
AIKnowledgeList = Class(AIBaseContainer)
private
public
end;
}
// ----------------------------------------------------------------------------

implementation

// ----------------------------------------------------------------------------
Constructor AIAction.Create(
    aParent: pointer;
    aOrigin: pointer;
    aKind: integer;
    aModifier: single;
    aTarget: pointer);
begin
  inherited Create(aParent);

  fOrigin := aOrigin;
  fKind := aKind;
  fModifier := aModifier;
  fTarget := aTarget;
end;

// ----------------------------------------------------------------------------
procedure AIAction.NilOrigin;
begin
  fOrigin := nil;
end;

// ----------------------------------------------------------------------------
procedure AIAction.NilTarget;
begin
  fTarget := nil;
end;

// ----------------------------------------------------------------------------
function AIAction.OneLineDisplay: string;
begin
  if Origin = nil then
    result := result + 'nil'
  else
    result := AIBaseObject(Origin).OneLineDisplay;
  if Kind = cActionEat then
    result := result + ' Eat ';
  if Target = nil then
    result := result + 'nil'
  else
    result := result + AIBaseObject(Target).OneLineDisplay;
end;

// ----------------------------------------------------------------------------
procedure AIActionList.AddAction(aAction: AIAction);
var
  myAction: AIAction;
begin
  myAction := AIAction.Create(
    self,
    aAction.Origin,
    aAction.Kind,
    aAction.Modifier,
    aAction.Target);
  Add(myAction);
end;

// ----------------------------------------------------------------------------
procedure AIActionList.NewAction(
  aOrigin: pointer;
  aAction: integer;
  aModifier: single;
  aTarget: pointer);
var
  myAIAction: AIAction;
begin
  myAIAction := AIAction.Create(
    self,
    aOrigin,
    aAction,
    aModifier,
    aTarget);

  Add(myAIAction);
end;

// ----------------------------------------------------------------------------
function AIActionList.HasNextAction: boolean;
begin
  result := false;
  if Count > 0 then
    result := true;
end;

// ----------------------------------------------------------------------------
function AIActionList.NextAction: AIAction;
begin
  result := AIAction(Items[0]);
end;

// ----------------------------------------------------------------------------
procedure AIGoal.CopyFrom(aGoal: AIGoal);
begin
  fOrigin := aGoal.Origin;
  fKind := aGoal.Kind;
  fModifier := aGoal.Modifier;
  fTarget := aGoal.Target;
  fAge := aGoal.Age;
  fFulfilled := aGoal.Fulfilled;
end;

end.

