{
  ai.planet
  http://aiplanet.sourceforge.net
  Created by Dave Kerr (kerrd@hotmail.com)
}
unit cAIBody;

interface

uses Classes, cAIBaseObject, cAIThings, cAIGrid, cAICoordinates,
  cAILife, cAIPosition, cAIForce;

const
  cSenseThings = 0;
  cSenseSmell = 1;
  cSenseHearing = 2;
  cSenseTemperature = 3;
  cSenseHumidity = 4;
  cSenseLight = 5;
  cSenseGrid = 6;
  cSenseTaste = 7;  // taste the health modifier of things

  cLimbLegs = 0;
  cLimbWings = 1;
  cLimbFins = 2;

  cOrganMouth = 0;
  cOrganStomach = 1;

  cActionBodyMove = 20;
  cActionBodyEat = 21;

type

// ============================================================================
AILimb = Class(AIBaseObject)
private
  fKind: integer;
  fForce: AIForce;
public
  property Kind: integer read fKind write fKind;
end;

// ============================================================================
AILimbList = Class(AIBaseContainer)
public
  function NewLimb(aKind: integer): AILimb;
end;

// ============================================================================
AISense = Class(AIBaseObject)
private
  fKind: integer;
  fForce: AIForce;
  fRadius: single;
//  fData: AISensoryData;
public
  property Kind: integer read fKind write fKind;
end;

// ============================================================================
AISenseList = Class(AIBaseContainer)
public
  function NewSense(aKind: integer): AISense;
end;

// ============================================================================
AIBody = Class(AIBaseObject)
private
  fUniqueID: integer;             // unique client ID
//  fRepresentation: integer;       // will substitute for any Thing.Kind

  fHealth: integer;

  fSenses: AISenseList;
  fLimbs: AILimbList;
//  fBrain: AIBrain;
protected
public
  property Health: integer read fHealth write fHealth;
  property Senses: AISenseList read fSenses;
  property Limbs: AILimbList read fLimbs;

  // queue action
  procedure Move;
  procedure Eat;
{  Constructor Create(aParent: pointer; aLocation: AIGrid);
  Destructor Destroy; override;

  function OneLineDisplay: string; override;

  procedure Fuel; override;

  // standard functionality
  procedure InterpretIncomingCommands(aCommandList: TStrings);
  procedure SendOutgoingData;

  procedure SaveToFile(var aFile: TextFile); override;
  procedure LoadFromFile(var aFile: TextFile); override;
  }
end;

implementation

uses
  cAIReality, cAIEnvironment, SysUtils, cAITrees, cAISatellites, contnrs,
  cAIFish, cAIBird, cAIExplosions, cUtilities, cGlobals;

// ----------------------------------------------------------------------------
procedure AIBody.Move;
begin

end;

// ----------------------------------------------------------------------------
procedure AIBody.Eat;
begin

end;

// ----------------------------------------------------------------------------
function AILimbList.NewLimb(aKind: integer): AILimb;
begin
  result := AILimb.Create(self);
  result.Kind := aKind;
end;

// ----------------------------------------------------------------------------
function AISenseList.NewSense(aKind: integer): AISense;
begin
  result := AISense.Create(self);
  result.Kind := aKind;
end;

end.

